-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_entdc.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_ENTITY_DECLARATION

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   entities : EIFFEL_ID_LIST
   
   entity_type : EIFFEL_TYPE

   parse is
      do
        !!entities.parse
        matchconsume(Elex_colon)
        !!entity_type.parse
      end

   defer, flat, short(f : EIFFEL_FORMAT) is
      do
         entities.short(f)
         f.normal_write(":")
         f.space
         entity_type.short(f)
      end

   supplier_classes : SET[STRING] is
      do
         Result := entity_type.supplier_classes
      end
      
   copy(other : like Current) is
      do
         entities := clone(other.entities)
         entity_type := clone(other.entity_type)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(entities,other.entities) and then
                   equal(entity_type, other.entity_type)
      end
      
end -- class EIFFEL_ENTITY_DECLARATION 
