-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/31 21:09:41 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_featbk.e $
	-- Revision 1.3  1993/07/31  21:09:41  Neil_Wilson
	-- Added feature block level comment processing.
	-- Alterations to parser and output features 'short' and 'defer'.
	--
	-- Revision 1.2  1993/07/18  13:48:26  Neil_Wilson
	-- Added 'defer' feature.
	-- Using different output formatter
	-- Altered 'short' output to conform to
	-- ETL 'standards'.
	-- Added feature 'available_to'
	-- Corrected feature "<".
	--

class EIFFEL_FEATURE_BLOCK

inherit
   EIFFEL_CONSTRUCT
   COMPARABLE
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   clients : EIFFEL_CLIENTS

   features : LLIST[EIFFEL_FEATURE_DECLARATION]

   featurec : EIFFEL_TOKEN

   parse is
      local
         afeature : EIFFEL_FEATURE_DECLARATION
      do
	 process_comment
         matchconsume(Elex_feature)
         if match(Elex_lbrace)
         then
            !!clients.parse
         end
         from
            !!features.make
         until
            match(Elex_feature) or match(Elex_end) or match(Elex_invariant)
         loop
            !!afeature.parse
            features.put(afeature)
            remove_semi
         end -- loop
      end -- parse

   -- Alteration, July 10, 1993
   -- Addtion of defer feature
   
   defer(f : EIFFEL_FORMAT) is
       do
             f.new_line
             f.keyword_write("feature")
             if clients = Void
             then
		debug -- standard style doesn't display this.
		    f.space
		    f.normal_write("{")
		    f.class_name_write("ANY")
		    f.normal_write("}")
		end
             else
                clients.defer(f)
             end -- if
             f.increase_indent
	     if featurec /= Void
	     then
		f.space
		featurec.defer(f)
	     end
             f.new_line
             from
                features.start
             until
                features.off_right
             loop
		    -- Alteration - Neil Wilson, July 17, 1993
		    -- Standard short dumps obsolete features
		if features.item.routine = Void
		    or else features.item.routine.obs = Void then
		    features.item.defer(f)
		end
		    -- End of alteration
                f.new_line
                features.forth
             end -- loop
             f.decrease_indent
       end  -- short

   short(f : EIFFEL_FORMAT) is
       do
             f.new_line
             f.keyword_write("feature specification")
             if clients = Void
             then
		debug -- standard style doesn't display this.
		    f.space
		    f.normal_write("{")
		    f.class_name_write("ANY")
		    f.normal_write("}")
		end
             else
		f.space
                clients.short(f)
             end -- if
             f.increase_indent
	     if featurec /= Void
	     then
		f.space
		featurec.short(f)
	     end
             f.new_line
             from
                features.start
             until
                features.off_right
             loop
		    -- Alteration - Neil Wilson, July 17, 1993
		    -- Standard short dumps obsolete features
		if features.item.routine = Void
		    or else features.item.routine.obs = Void then
		    features.item.short(f)
		end
		    -- End of alteration
                f.new_line
                features.forth
             end -- loop
             f.decrease_indent
       end  -- short

   -- End of alteration - add defer

   normal : SLLIST[VERSION]

   normalise is
      do
        from
           !!normal.make
           features.start
        until
           features.off_right
        loop
           debug
              io.putstring("Feature block normalise call to a feature%N")
           end
           features.item.normalise
           from
              features.item.normal.start
           until
              features.item.normal.off_right
           loop
              features.item.normal.item.set_export(clone(clients))
              features.item.normal.forth
           end
           normal.append(features.item.normal)
           debug
              io.putint(normal.count)
              io.new_line
           end
           features.forth
        end
      end

     -- Alteration, Neil Wilson, July 11, 1993
     -- Added 'available_to' feature
     
   available_to (class_name : STRING): BOOLEAN is
   	-- Is this feature block exported to class_name ?
   require
   	class_name_available: class_name /= Void and then not class_name.empty
   do
   	class_name.to_lower;
   	Result := equal (class_name, "none") -- 'See all' class
		or clients = Void -- Publicly available 
		or else clients.contains ("any")
		or else clients.contains (class_name);
   end -- available_to

     -- End of alteration

   infix "<" (other : like Current) : BOOLEAN is
      do
	     -- Alteration, Neil Wilson, July 18, 1993
	     -- Correct 'anti-symmetric' post condition violation
         Result := ((clients /= Void and
                    other.clients /= Void) and then 
                    clients < other.clients)
                  or
		    
                    (clients = Void and other.clients /= Void)
	     -- End of alteration
      end
      
   supplier_classes : SET[STRING] is
      do
         !!Result
         from
            features.start
         until
            features.off_right
         loop
            Result.union(features.item.supplier_classes)
            features.forth
         end
      end

   flat(f : EIFFEL_FORMAT) is
       do
       end  -- flat
       
   copy(other : like Current) is
      do
         clients := clone(other.clients)
         features := clone(other.features)
         normal := clone(other.normal)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(clients,other.clients) and then
                   equal(features,other.features) and then
                   equal(normal,other.normal)
      end

      -- Alteration - Neil Wilson  July 31, 1993

feature {NONE} -- feature level comment processing

   process_comment is
      do
         mark
         from
         until
            (l.current_char='-' and l.next_char = '-') or
            l.current_char = '%N'
         loop
            l.get_next_char
         end
         accept_comments
         consume
         ignore_comments
         if match(Elex_comment)
         then
            !!featurec.parse
         end
         return
      end

      -- End of alteration
      
end -- class EIFFEL_FEATURE_BLOCK
