-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:12:28 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_featdc.e $
	-- Revision 1.2  1993/07/18  14:12:28  Neil_Wilson
	-- Added 'defer' feature
	-- Using different output formatter
	-- Added ability to 'mark' constants as such.
	--

class EIFFEL_FEATURE_DECLARATION
-- The declaration of a feature includes its names
-- arguments, result type and body which may be a routine

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   feature_names : LLIST[EIFFEL_FEATURE_NAME]
   formals : LLIST[EIFFEL_ENTITY_DECLARATION]
   result_type : EIFFEL_TYPE 
   uniq : EIFFEL_TOKEN
   routine : EIFFEL_ROUTINE
   constant : EIFFEL_MANIFEST_CONSTANT
   featurec : EIFFEL_TOKEN

   parse is
      local
         ed : EIFFEL_ENTITY_DECLARATION
         fn : EIFFEL_FEATURE_NAME
      do
         !!feature_names.make
         from
            if match(Elex_frozen)
            then
               consume
               !EIFFEL_FROZEN_FEATURE!fn.parse
            else
               !!fn.parse
            end
            feature_names.put(fn)
         until
            not match(Elex_comma)
         loop
            consume -- ,
            if match(Elex_frozen)
            then
               consume
               !EIFFEL_FROZEN_FEATURE!fn.parse
            else
               !!fn.parse
            end
            feature_names.put(fn)
         end
         if match(Elex_lbracket)
         then
            -- formal args
            consume
            !!formals.make
            from
            until
               match(Elex_rbracket)
            loop
               !!ed.parse
               formals.put(ed)
               if match(Elex_comma) -- "," for Eiffel/S
               then
                  consume
               end
               remove_semi
            end
            consume -- ")"
         end
         process_comment
         if match(Elex_colon) 
         then
            consume
            !!result_type.parse
         end
         if match(Elex_is)
         then
            consume
            if match(Elex_unique)
            then
               !!uniq.parse
		  -- Alteration, Neil Wilson, July 17, 1993
	       mark_constants
		  -- End of alteration
               consume
            elseif match(Elex_obsolete) or match(Elex_require) or
                   match(Elex_local) or match(Elex_do) or match(Elex_once)
                   or match(Elex_deferred) or match(Elex_external)
            then
               !!routine.parse
            else
               !!constant.parse
		  -- Alteration, Neil Wilson, July 17, 1993
	       mark_constants
		  -- End of alteration
            end
         end
      end

   -- Alteration - Neil Wilson, July 11, 1993
   -- Addition of defer feature
   
   defer (f : EIFFEL_FORMAT) is
      local
         marker: EIFFEL_FEATURE_NAME
      do
         f.new_line
         from
            feature_names.start
            feature_names.item.defer(f)
	    marker := feature_names.item
            feature_names.forth
         until
            feature_names.off_right
         loop
            f.normal_write(",")
            f.new_line
            feature_names.item.defer(f)
            feature_names.forth
         end
         if formals /= Void and then not formals.empty
         then
	    f.space
            f.normal_write("(")
            from
               formals.start
               formals.item.defer(f)
               formals.forth
            until
               formals.off_right
            loop
               f.normal_write(";")
               f.space
               formals.item.defer(f)
               formals.forth
            end
            f.normal_write(")")
         end
         if result_type /= Void
         then
            f.normal_write(":")
            f.space
            result_type.defer(f)
         end
	 f.space
	 f.keyword_write ("is")
         if featurec /= Void
         then
            f.increase_indent
            f.increase_indent
            f.new_line
            featurec.defer(f)
            f.decrease_indent
            f.decrease_indent
         end
         if routine /= Void 
         then
            routine.defer(f)
	 else
	    f.increase_indent
	    f.new_line
	    f.keyword_write ("deferred");
	    f.decrease_indent
         end
	 f.new_line
	 f.keyword_write ("end");
	 f.space
	 f.normal_write ("--");
	 f.space
	 marker.defer (f)
      end

  -- End of alteration

   short(f : EIFFEL_FORMAT) is
      do
         f.new_line
         from
            feature_names.start
            feature_names.item.short(f)
            feature_names.forth
         until
            feature_names.off_right
         loop
            f.normal_write(",")
            f.new_line
            feature_names.item.short(f)
            feature_names.forth
         end
         if formals /= Void and then not formals.empty
         then
	    f.space
            f.normal_write("(")
            from
               formals.start
               formals.item.short(f)
               formals.forth
            until
               formals.off_right
            loop
               f.normal_write(";")
               f.space
               formals.item.short(f)
               formals.forth
            end
            f.normal_write(")")
         end
         if result_type /= Void
         then
            f.normal_write(":")
            f.space
            result_type.short(f)
         end
         if constant /= Void
         then
            f.space
            f.keyword_write("is")
            f.space
            constant.short(f)
         elseif uniq /= Void
         then
            f.space
            f.keyword_write("is")
            f.space
            f.keyword_write("unique")
         end
         if featurec /= Void
         then
            f.increase_indent
            f.increase_indent
            f.new_line
            featurec.short(f)
            f.decrease_indent
            f.decrease_indent
         end
         if routine /= Void 
         then
            routine.short(f)
         end
      end

feature {EIFFEL_FEATURE_BLOCK, EIFFEL_FEATURE_DECLARATION}

   normal : SLLIST[VERSION]

   normalise is
   -- normalise this so that there is one feature name for
   -- each feature declaration
   -- do this by duplication of the feature bodys and arguments
      local       
         nf : VERSION
      do
         from
            !!normal.make
            feature_names.start
         until
            feature_names.off_right
         loop
            debug
               io.putstring("Calling to make a normal feature%N")
            end
            !!nf.make(clone(feature_names.item),clone(formals),
                      clone(result_type),clone(routine),clone(constant),
                      clone(featurec),clone(uniq))
            normal.put(nf)
            feature_names.forth
         end
      end

feature {NONE}

   process_comment is
      do
         mark
         from
         until
            (l.current_char='-' and l.next_char = '-') or
            l.current_char = '%N'
         loop
            l.get_next_char
         end
         accept_comments
         consume
         ignore_comments
         if match(Elex_comment)
         then
            !!featurec.parse
         end
         return
      end

      -- Alteration - Neil Wilson, July 17, 1993
      -- Feature names need to know if they're constants

   mark_constants is
	 -- Notify feature identifiers that current declaration is a constant
      require
	 constant_dec: constant /= Void or uniq /= Void
      do
         from
            feature_names.start
	    feature_names.item.name.set_constant
            feature_names.forth
         until
            feature_names.off_right
         loop
	    feature_names.item.name.set_constant
            feature_names.forth
         end
      end -- mark_constants

      -- End of alteration
	 
feature {ANY}

   flat(f : EIFFEL_FORMAT) is
      do
      end
      
   copy(other : like Current) is
      do
         feature_names := clone(other.feature_names)
         formals := clone(other.formals)
         result_type := clone(other.result_type)
         uniq := clone(other.uniq)
         routine := clone(other.routine)
         constant := clone(other.constant)
         featurec := clone(other.featurec)
         normal := clone(other.normal)
      end

   is_equal(other : like Current): BOOLEAN is
      do
         Result :=
            equal(feature_names,other.feature_names) and then
            equal(formals,other.formals) and then
            equal(result_type,other.result_type) and then
            equal(uniq,other.uniq) and then
            equal(routine,other.routine) and then
            equal(constant,other.constant) and then
            equal(featurec,other.featurec) and then
            equal(normal,other.normal)
      end
      
   supplier_classes : SET[STRING] is
      do
         !!Result
         if result_type /= Void
         then
            Result.union(result_type.supplier_classes)
         end
         if formals /= Void
         then
            from
               formals.start
            until
               formals.off_right
            loop
               Result.union(formals.item.supplier_classes)
               formals.forth
            end
         end -- if
         if routine /= Void
         then
            Result.union(routine.supplier_classes)
         end
      end

end -- class EIFFEL_FEATURE_DECLARATION
