-- Eiffel class format skeleton

indexing
	
	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/07/18 14:18:19 $";
	revision: "$Revision: 1.1 $";
	licence: "GNU GPL - see file COPYING";
	log: 
	-- $Log: e_format.e $
	-- Revision 1.1  1993/07/18  14:18:19  Neil_Wilson
	-- Initial revision
	--
	
deferred class EIFFEL_FORMAT

feature -- Comb indent facilities

	indent_level : INTEGER 
		-- The current indent level.

	increase_indent is
		-- Move the indent_level up.
	do
		indent_level := indent_level + 1
	ensure
		indent_level > old indent_level
	end -- increase_indent

	decrease_indent is
	require
		decreasable: indent_level > 0;
	do
		indent_level := indent_level - 1
	ensure
		indent_level < old indent_level
	end -- decrease_indent

	drop_indent is
		-- Clear the line indent
	do
		indent_level := 0
	ensure
		dropped: indent_level = 0;
	end -- drop_indent

	set_indent (num: INTEGER) is
		-- Move the indent to a specific value.
	require
		positive_indent: num >= 0
	do
		indent_level := num
	ensure
		set: indent_level = num
	end;

	indent is
		-- Move in another indent on current_line
	deferred
	ensure
		indent_level_up: indent_level > old indent_level
	end -- indent

feature -- Line length facilities

	width: INTEGER;
		-- The maximum width of the output medium.

	set_width (num: INTEGER) is
		-- Change the maximum output width
	require
		sensible_width: num > 20 -- character based
	do
		width := num
	ensure
		width = num
	end -- set_width

feature {NONE} -- private output manipulators

	write (s: STRING) is
		-- Output the string in the current format
	require
		s /= Void
	do
		if over_width (s) then
			temp_indent := true;
			new_line;
		end;
		output (s);
		add_length (s);
	end -- write

feature -- output manipulators

	new_line is
		-- Auto indent to next line.
	do
		output ("%N");
		indent_line;
	end -- new_line;

	end_output is
		-- Finish formatting
	deferred
	end -- end_output

feature -- Eiffel class output facilities

	constant_write (s: STRING) is
		-- Output 's' in Constant format
	require
		s /= Void
	local
		up: STRING
	do
		up := clone (s)
		up.to_lower
		if not up.empty then
			up.put (up.item (1).to_upper, 1);
		end;
		italic_on
		write (up)
		italic_off
	end -- constant_write

	keyword_write (s: STRING) is
		-- Output 's' in keyword format
	require
		s /= Void
	local
		up: STRING
	do
		up := clone (s)
		up.to_lower
		bold_on
		write (up)
		bold_off
	end -- keyword_write

	class_name_write (s: STRING) is
		-- Output 's' in keyword format
	require
		s /= Void
	local
		up: STRING
	do
		up := clone (s)
		up.to_upper
		italic_on
		write (up)
		italic_off
	end -- class_name_write

	comment_write (s: STRING) is
		-- Output 's' in comment format
	require
		s /= Void
	do
		write (s)
	end -- comment_write

	normal_write (s: STRING) is
		-- Output 's' without any formatting
	require
		s /= Void
	do
		write (s)
	end -- normal_write

	attribute_write (s: STRING) is
		-- Output 's' in attribute format
	require
		s /= Void
	local
		up: STRING
	do
		up := clone (s)
		up.to_lower
		italic_on
		write (s)
		italic_off
	end -- attribute_write

	separator is
		-- Output eiffel separator
	deferred
	end -- separator

	space is
		-- Output white space
	deferred
	end -- space

feature {NONE} -- Line length facilties

	over_width (s: STRING): BOOLEAN is
		-- Does 's' take the formatter over 'width'?
	require
		s /= Void
	do
		Result := current_width + s.count >= width
	end -- over_width

	add_length (s: STRING) is
		-- Change 'current_width' according to length of 's'.
	require
		s /= Void
	do
		current_width := current_width + s.count
	end -- add_length

	current_width: like width

feature {NONE} -- Indent facilities

	temp_indent: BOOLEAN
		-- Ask for the indent to be temporarily increased.

	indent_line is
		-- Set up the correct indent level.
	deferred
	ensure
		temp_off: not temp_indent
	end -- set_indent

feature {NONE} -- Output generator

	output (s: STRING) is
		-- Place string on output medium
	require
		s /= Void
	deferred
	end -- output

	bold_on, bold_off, italic_on, italic_off is
		-- Typesetting features
	deferred
	end -- bold_on

invariant

	positive_width: width >= 0 and current_width >= 0;
	positive_indent: indent_level >= 0;

end -- class EIFFEL_FORMAT
