-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_formlg.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_FORMAL_GENERICS

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   generics : LLIST[EIFFEL_CONSTRAINED_GENERIC]

   parse is
      local
         cg : EIFFEL_CONSTRAINED_GENERIC
      do
         matchconsume(Elex_lsqbracket)
         from
            !!cg.parse
            !!generics.make
            generics.put(cg)
         until
            match(Elex_rsqbracket)
         loop
            matchconsume(Elex_comma)
            !!cg.parse
            generics.put(cg)
         end
         matchconsume(Elex_rsqbracket)
      end

   defer, flat, short(f : EIFFEL_FORMAT) is
      do
         from
            generics.start
	    f.space
            f.normal_write("[")
            generics.item.short(f)
            generics.forth
         until
            generics.off_right
         loop
            f.normal_write(",")
	    f.space
            generics.item.short(f)
            generics.forth
         end
         f.normal_write("]")
      end
      
   copy(other : like Current) is
      do
         generics := clone(other.generics)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(generics,other.generics)
      end
      
end -- class EIFFEL_FORMAL_GENERIC
