-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/01 09:55:03 $";
	revision: "$Revision: 1.3 $";
	log: 
	-- $Log: e_idlist.e $
	-- Revision 1.3  1993/08/01  09:55:03  Neil_Wilson
	-- Altered list termination check
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_ID_LIST

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
    
feature

   values : LLIST[EIFFEL_TOKEN]

   parse is
      local
         t : EIFFEL_TOKEN
      do
         from
            !!values.make
         until
	    -- Alteration - Neil Wilson  July 31, 1993
	    not match (Elex_id)
	    -- End of alteration
         loop
            !!t.parse
            values.put(t)
            matchconsume(Elex_id)
            if match(Elex_comma)
            then
               consume -- ,
            end
         end -- loop
      end -- id_list

   contains(s : STRING) : BOOLEAN is
      require
         values /= Void
         not values.empty
      do
        from
           values.start
        until
           values.off_right or Result
        loop
           Result := equal(values.item.terminal,s)
           values.forth
        end -- loop
      end -- contain

   upshort(f : EIFFEL_FORMAT) is
      do
        from
           values.start
           values.item.upshort(f)
           values.forth
        until
           values.off_right 
        loop
           f.normal_write(",")
	   f.space
           values.item.upshort(f)
           values.forth
        end -- loop
     end -- up short

   defer, flat,short(f : EIFFEL_FORMAT) is
      do
        from
           values.start
           values.item.short(f)
           values.forth
        until
           values.off_right 
        loop
           f.normal_write(",")
	   f.space
           values.item.short(f)
           values.forth
        end -- loop
      end
      
   copy(other : like Current) is
      do
         values := clone(other.values)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(values,other.values)
      end
      
end -- class  EIFFEL_ID_LIST
