-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/08/01 09:47:26 $";
	revision: "$Revision: 1.3 $";
	author: "David Morgan";
	log: 
	-- $Log: e_indexc.e $
	-- Revision 1.3  1993/08/01  09:47:26  David_Morgan
	-- Redesigned index clause support
	--
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_INDEX_CLAUSE
-- The details about a single index

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      

creation
   parse
   
feature 

   index_name : EIFFEL_TOKEN

   keys : LLIST[EIFFEL_CONSTRUCT]

   parse is
      local
         value : EIFFEL_CONSTRUCT
      do
         mark
         matchconsume(Elex_id)
         if match(Elex_colon)
         then
            return
            !!index_name.parse
            consume -- id
            accept_comments
            consume -- :
            from
               !!keys.make
               if match(Elex_id) or match(Elex_comment)
               then
                  !EIFFEL_TOKEN!value.parse
                  consume
               else
                  !EIFFEL_MANIFEST_CONSTANT!value.parse
               end -- if
               keys.put(value)
            until
               not match(Elex_comma)
               -- not match(Elex_id) and not match(Elex_string) and 
               -- not match(Elex_real) and not match(Elex_int) and
               -- not match(Elex_comment)
            loop
               consume -- ,
               if match(Elex_id) or match(Elex_comment)
               then
                  !EIFFEL_TOKEN!value.parse
                  consume
               else
                  !EIFFEL_MANIFEST_CONSTANT!value.parse
               end -- if
               keys.put(value)
            end -- loop
            ignore_comments
         else
            from
               !!keys.make
               if match(Elex_id) 
               then
                  !EIFFEL_TOKEN!value.parse
                  consume
               else
                  !EIFFEL_MANIFEST_CONSTANT!value.parse
               end -- if
               keys.put(value)
            until
               -- not match(Elex_id) and not match(Elex_string) and 
               -- not match(Elex_real) and not match(Elex_int) 
               not match(Elex_comma)
            loop 
               consume -- ,
               if match(Elex_id) 
               then
                  !EIFFEL_TOKEN!value.parse
                  consume
               else
                  !EIFFEL_MANIFEST_CONSTANT!value.parse
               end -- if
               keys.put(value)
            end -- loop
         end -- if
      end -- index_clause

   defer, short(f : EIFFEL_FORMAT) is
      do
      end -- short
      
   flat(f : EIFFEL_FORMAT) is
      do
      end
      
   copy(other : like Current) is
      do
         index_name := clone(other.index_name)
         keys := clone(other.keys)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result :=
            equal(index_name, other.index_name) and then
            equal(keys, other.keys)
      end
      
end -- class EIFFEL_INDEXING   
