-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_instru.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_INSTRUCTION

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   instruction : EIFFEL_CONSTRUCT

   parse is
      local
         right,t : EIFFEL_EXPRESSION
         left,op : EIFFEL_TOKEN
      do
         if match(Elex_bang)
            -- creation
         then
            !EIFFEL_CREATION!instruction.parse
         elseif match(Elex_if)
            -- conditional
         then
            !EIFFEL_IF!instruction.parse
         elseif match(Elex_inspect)
            -- multi branch
         then   
            !EIFFEL_MULTI_BRANCH!instruction.parse
         elseif match(Elex_from)
         then
            -- loop
            !EIFFEL_LOOP!instruction.parse
         elseif match(Elex_debug)
         then
            -- debug
            !EIFFEL_DEBUG!instruction.parse
         elseif match(Elex_check)
         then
            -- check
            !EIFFEL_CHECK!instruction.parse
         elseif match(Elex_retry)
         then
            -- retry
            !EIFFEL_TOKEN!instruction.parse
            matchskip(Elex_retry)
         elseif match(Elex_lbracket)
         then
            -- definitely call
            !EIFFEL_CALL!instruction.parse
         elseif match(Elex_end) or match(Elex_rescue) or match(Elex_semi)
         then
             -- empty instruction
         else
            if match(Elex_id) or match(Elex_result)
            then
               mark
               !!left.parse
               skip
               if match(Elex_assign) or match(Elex_revassign)
               then
                  return
                  !EIFFEL_ASSIGNMENT!instruction.parse
               else
                  return
                  !EIFFEL_CALL!instruction.parse
                  -- call           
               end  -- if
            end -- if
         end -- if
      end -- parse

   defer, short(f : EIFFEL_FORMAT) is
      do
      end
      
   flat(f : EIFFEL_FORMAT) is
      do
         if instruction /= Void
         then
            instruction.flat(f)
         end
      end
      
   copy(other : like Current) is
      do
         instruction := clone(other.instruction)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(instruction,other.instruction)
      end
      
end -- class EIFFEL_INSTRUCTION
