-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_mconst.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_MANIFEST_CONSTANT
-- A manifest constant such as a number etc

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
              
creation
   parse
   
feature

    value : EIFFEL_TOKEN

    parse is
      local
         sign : EIFFEL_TOKEN
      do
         if match(Elex_plus) or match(Elex_minus) 
         then
            !!sign.parse
            consume
            if match(Elex_real) or match(Elex_int)
            then
               !!value.parse
               value.terminal.prepend(sign.terminal)
               consume
            end
         elseif match(Elex_true) or match(Elex_false) or
                match(Elex_int) or match(Elex_real) or
                match(Elex_char) or match(Elex_string) or
                match(Elex_bitseq)
         then -- a constant
            !!value.parse
            consume
         end -- if
      end

   defer, flat,short(f : EIFFEL_FORMAT) is
      do
         value.short(f)
      end

   copy(other : like Current) is
      do
         value := clone(other.value)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := equal(value,other.value)
      end
      
end -- class EIFFEL_MANIFEST_CONSTANT

