-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_multib.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_MULTI_BRANCH
-- The inspect statement

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   inspect_expression : EIFFEL_EXPRESSION

   when_parts : LLIST[EIFFEL_WHEN]

   else_part : EIFFEL_COMPOUND

   parse is
      local
         t : EIFFEL_WHEN
      do
         !!when_parts.make
         matchconsume(Elex_inspect)
         !!inspect_expression.parse
         from
            !!t.parse
            when_parts.put(t)
         until
            not match(Elex_when)
         loop
            !!t.parse
            when_parts.put(t)
         end -- loop
         if match(Elex_else)
         then
            consume
            !EIFFEL_COMPOUND!else_part.parse
         end
         matchconsume(Elex_end)
      end -- parse

   defer, short(f : EIFFEL_FORMAT) is
      do
      end
      
   flat(f : EIFFEL_FORMAT) is
      do
      end
      
   copy(other : like Current) is
      do
         inspect_expression := clone(other.inspect_expression)
         when_parts := clone(other.when_parts)
         else_part := clone(other.else_part)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result :=
            equal(inspect_expression,other.inspect_expression) and then
            equal(when_parts,other.when_parts) and then
            equal(else_part,other.else_part)
      end
      
end -- class EIFFEL_MULTI_BRANCH      
