-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_newexp.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_NEW_EXPORTS

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   clients : LLIST[EIFFEL_CLIENTS]
    
   features : LLIST[EIFFEL_CONSTRUCT]

   parse is
      do
         !!clients.make
         !!features.make
         from
         until
            match(Elex_undefine) or match(Elex_redefine) or match(Elex_select)
            or match(Elex_end)
         loop
            new_export
            remove_semi
         end -- loop         
      end

   new_export is
      local
         c : EIFFEL_CLIENTS
         fl: EIFFEL_CONSTRUCT
      do
         !!c.parse
         if match(Elex_all)
         then
            !EIFFEL_TOKEN!fl.parse
            consume -- all
         elseif match(Elex_id) -- a feature list
         then
            !EIFFEL_SORTED_ID_LIST!fl.parse
         end
         clients.put(c)
         features.put(fl)
      end

   defer, flat, short(f : EIFFEL_FORMAT) is
      do
         from
            clients.start
            features.start
            clients.item.short(f)
            f.space
            features.item.short(f)
            clients.forth
            features.forth
         until
            clients.off_right
         loop
            f.new_line
            clients.item.short(f)
            f.space
            features.item.short(f)
            clients.forth
            features.forth
         end
      end
      
   copy(other : like Current) is
      do
         clients := clone(other.clients)
         features := clone(other.features)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := 
            equal(clients, other.clients) and then
            equal(features, other.features)
      end
      
end -- class EIFFEL_NEW_EXPORT
