-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_rename.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_RENAME
-- the rename clause of a parent

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   old_names, new_names : LLIST[EIFFEL_TOKEN]
   
   parse is
      do
         !!old_names.make
         !!new_names.make
         from
         until
            match(Elex_end) or match(Elex_undefine) or match(Elex_redefine)
            or match(Elex_select) or match(Elex_export)
         loop
            process_pair
            if match(Elex_comma)
            then
               consume
            end
         end -- loop
      end

   process_pair is
      local
         old_name, new_name : EIFFEL_TOKEN
      do
         !!old_name.parse
         matchconsume(Elex_id)
         matchconsume(Elex_as)
         !!new_name.parse
         matchconsume(Elex_id)
         old_names.put(old_name)
         new_names.put(new_name)
      end --

   defer, short(f : EIFFEL_FORMAT) is
      do
         if not old_names.empty
         then
            from
               old_names.start
               new_names.start
               old_names.item.short(f)
               f.space
               f.keyword_write("as")
               f.space
               new_names.item.short(f)
               old_names.forth
               new_names.forth
            until
               old_names.off_right
            loop
               f.normal_write(",")
               f.new_line
               old_names.item.short(f)
               f.space
               f.keyword_write("as")
               f.space
               new_names.item.short(f)
               old_names.forth
               new_names.forth
            end
         end
      end
      
   flat(f : EIFFEL_FORMAT) is
      do
      end
      
   copy(other : like Current) is
      do
         old_names := clone(other.old_names)
         new_names := clone(other.new_names)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := 
            equal(old_names, other.old_names) and then
            equal(new_names, other.new_names)
      end
      
end -- class EIFFEL_RENAME  
