-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_unqcal.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_UNQUALIFIED_CALL
-- A call without the dots

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse
   
feature

   arguments : LLIST[EIFFEL_CONSTRUCT]
   
   feature_name : EIFFEL_TOKEN

   parse is
      do
         if match(Elex_result) or match(Elex_current)
         then
            !!feature_name.parse
            consume
         else
            !!feature_name.parse
            matchconsume(Elex_id)
            if match(Elex_lbracket)
            then
               !!arguments.make
               consume
               from
                  process_arg
               until
                  not match(Elex_comma)
               loop
                  consume
                  process_arg
               end -- loop               
               matchconsume(Elex_rbracket)
            end -- if
         end -- if
      end
      
   process_arg is
      local
         t : EIFFEL_EXPRESSION
         arg : EIFFEL_TOKEN
      do
         if match(Elex_dollar)
         then
            consume
            !!arg.parse
            matchconsume(Elex_id)
            arg.terminal.prepend("$")
            arguments.put(arg)
         else
            !!t.parse
            arguments.put(t)
         end -- if
      end -- process_arg

   defer, flat,short(f : EIFFEL_FORMAT) is
      do
         feature_name.short(f)
         if arguments /= Void
         then
            f.normal_write("(")
            from
               arguments.start
               arguments.item.short(f)
               arguments.forth
            until
               arguments.off_right
            loop
               f.normal_write(",")
	       f.space
               arguments.item.short(f)
               arguments.forth
            end
            f.normal_write(")")
         end -- if
      end
      
   copy(other : like Current) is
      do
         feature_name := clone(other.feature_name)
         arguments := clone(other.arguments)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result :=
            equal(feature_name,other.feature_name) and then
            equal(arguments, other.arguments)
      end
      
end -- class EIFFEL_UNQUALIFIED_CALL
