-- **************************************************************************
-- *  Elexer : Classes for Parsing Eiffel 3 written in Eiffel               *
-- *  Copyright (C) 1993 David Morgan                                       *
-- *                                                                        *
-- *  This program is free software; you can redistribute it and/or modify  *
-- *  it under the terms of the GNU General Public License as published by  *
-- *  the Free Software Foundation; either version 2 of the License, or     *
-- *  (at your option) any later version.                                   *
-- *                                                                        *
-- *  This program is distributed in the hope that it will be useful,       *
-- *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
-- *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
-- *  GNU General Public License for more details.                          *
-- *                                                                        *
-- *  You should have received a copy of the GNU General Public License     *
-- *  along with this program; if not, write to the Free Software           *
-- *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
-- *                                                                        *
-- *          e-mail                       s-mail                           *
-- *      morgan@socs.uts.edu.au           David Morgan                     *
-- *                                       School of Computing Sciences     *
-- *                                       University of Technology         * 
-- *                                       Po Box 123                       *  
-- *                                       Broadway 2007                    *
-- *                                       Australia                        *
-- **************************************************************************  

indexing

	date: "$Date: 1993/07/18 14:57:02 $";
	revision: "$Revision: 1.2 $";
	log: 
	-- $Log: e_when.e $
	-- Revision 1.2  1993/07/18  14:57:02  Neil_Wilson
	-- Added 'defer' feature.
	-- Using new output formatter.
	-- Short output altered to conform to
	-- ETL 'standard'.
	--

class EIFFEL_WHEN
-- The when parts of inspect statements

inherit
   EIFFEL_CONSTRUCT
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   parse

feature

   values : LLIST[EIFFEL_CONSTRUCT]

   body : EIFFEL_COMPOUND

   parse is
      do
         matchconsume(Elex_when)
         from
            !!values.make
            when_value
         until
            not match(Elex_comma)
         loop
            consume -- ,
            when_value
         end -- loop                  
         matchconsume(Elex_then)
         !!body.parse
      end

   when_value is
      local
         lt, rt, lb : EIFFEL_CONSTRUCT
         exp : EIFFEL_EXPRESSION
      do
         if match(Elex_id) or match(Elex_int) or match(Elex_char)
         then
            !EIFFEL_TOKEN!lt.parse
            consume
            if match(Elex_dotdot)
            then
               !EIFFEL_TOKEN!lb.parse
               consume
               if match(Elex_id) or match(Elex_int) or
                  match(Elex_char)
               then
                  !EIFFEL_TOKEN!rt.parse
                  consume
                  !!exp.make(lb,lt,rt)
                  values.put(exp)
               else
                  error("Missing end expression after ..")
               end
            else
               values.put(lt)
            end
         else
            error("Invalid token for when")
         end
      end

   defer, short(f : EIFFEL_FORMAT) is
      do
      end
   flat(f : EIFFEL_FORMAT) is
      do
      end
      
   copy(other : like Current) is
      do
         values := clone(other.values)
         body := clone(other.body)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := 
            equal(values, other.values) and then
            equal(body, other.body)
      end
      
end -- class EIFFEL_WHEN
