indexing
	
	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/07/17 13:55:30 $";
	revision: "$Revision: 1.3 $";
	licence: "GNU GPL - see file COPYING";
	log: 
	-- $Log: lexical.e $
	-- Revision 1.3  1993/07/17  13:55:30  Neil_Wilson
	-- Changed lexical exception mechanism.
	-- Exception generates longer string sequence
	-- and no output is displayed on screen at point
	-- exception is raised
	--
	-- Revision 1.2  1993/06/30  20:01:45  Neil_Wilson
	-- Lexer decoupled from input stream.
	--
	-- Revision 1.1  1993/06/27  09:23:46  David_Morgan
	-- Initial revision
	--
	
deferred class LEXICAL
-- a lexical analyser for Eiffel

inherit
   
   EXCEPTION
   
   LEXICAL_CONSTANT
   
   REWINDABLE_CHARACTER_STREAM
   	rename
		end_of_stream as eof
	end

   -- Alteration - Neil Wilson, July 10, 1993

   FORMAT

   -- End of alteration

feature
 
   make is
      do
        delimiters := "%""
        delimiters.append(whitespace)
        !!terminals.make
        next_token := ""
        create_lex
      end

feature -- Stream manipulators
	-- Added by Neil Wilson - June 27, 1993

	connect_stream (str: like stream) is
		-- Use 'str' as the input to the lexer
	require
		stream_operating: str /= Void
	do
		stream := str
		consume
	end -- connect_stream

	eof: BOOLEAN is
		-- Are we at the end of the character stream?
	do
		Result := stream.end_of_stream
	end -- eof

	current_line: INTEGER is
		-- The count of newlines in the stream
	do
		Result := stream.current_line
	end -- current_line

	mark is
		-- Mark a return point in the stream
	do
		marked_token := clone(next_token)
		marked_tokent := token_type
		stream.mark
	end -- mark

	return is
		-- Return to the last marked point.
	do
		next_token := marked_token
		token_type := marked_tokent
		stream.return
	end -- return

	is_marked: BOOLEAN is
		-- Is a mark still current in the stream?
	do
		Result := stream.is_marked
	end -- is_marked

	is_connected: BOOLEAN is
		-- Is stream connected to some characters?
	do
		Result := stream.is_connected
	end -- is_connected

	close is
		-- Prevent further access to stream
	do
		stream.close
	end -- close
	
	current_char: CHARACTER is
		-- Current character in stream
	do
		Result := stream.current_char
	end -- current_char

	get_next_char is
		-- Retrieve the next character from the stream
	do
		stream.get_next_char
	end -- get_next_char

	next_char: CHARACTER is
		-- Look at next character on the stream
	do
		Result := stream.next_char
	end -- next_char

feature {NONE} -- Private stream manipulators

	stream: REWINDABLE_CHARACTER_STREAM
    
	marked_tokent : like token_type
	marked_token : like next_token

	-- end of insertion

feature

   delimiters : STRING

   add_delimiter(s : STRING; v : INTEGER) is
      require
         s /= Void
         s.count = 1
         v /= 0
      do
         add_terminal(s, v)
         delimiters.extend(s.item(1))       
      end
     
   add_terminal(t : STRING; v : INTEGER) is 
      local
         s : STRING
      do
         s := clone(t)
         s.to_lower
         terminals.put(s,v)
      end
  
   terminals : TRIE
   
   match(v : INTEGER) : BOOLEAN is
      do
         Result := token_type = v
      end

   next_token : STRING
   
   skip_white_space is
      do
         from
         until
            not in(current_char,whitespace) or eof
         loop
            get_next_char
         end
      end

   whitespace : STRING is "%T%N%R "
   
   in(c : CHARACTER; s : STRING) : BOOLEAN is 
      local
         i : INTEGER
      do
         from
            i := 1
         until
            i > s.count or else s.item(i) = c
         loop
            i := i + 1
         end
         Result := i <= s.count and then s.item(i) = c
      end

   get_comments : BOOLEAN
   
   accept_comments is
      do
         get_comments := true
      end
   
   ignore_comments is
      do
         get_comments := false
      end

   collect_to_delimiter is
      do
         from
         until
            in(current_char,delimiters) or eof
         loop
            next_token.extend(current_char.to_lower)
            get_next_char
         end
      end

   matchconsume(v : INTEGER) is
      local
         t : STRING
      do
        if match(v)
        then
           consume
        else
           t := "Found "
           t.append(next_token)
           t.append("%N")
           raise("matchconsume",t,1,void)
        end
     end

   consume is
      do
         from
            get_next_token
         until
            not equal(next_token,comment_start) or eof
         loop
            if get_comments
            then
               token_type := Lex_comment
               from
                  collect_to_end_of_line
               until
                  (current_char /= comment_start.item(1) and 
                  next_char /= comment_start.item(2)) or eof
               loop
                  collect_to_end_of_line
               end
            else
               collect_to_end_of_line
               skip_white_space
               get_next_token
            end   
         end -- loop
         debug
            io.putstring(next_token)
         end
      end -- consume

   collect_to_end_of_line is
      do
         from
         until
            current_char = '%N' or current_char = '%R' or eof
         loop
            next_token.extend(current_char)
            get_next_char
         end -- if
         next_token.extend('%N')
         skip_white_space
      end

   comment_start : STRING is
      deferred
      end

   create_lex is
      deferred
      end

   get_next_token is
      -- gets the next token sets up all other required details
      do
         next_token := ""         
         token_type := 0
         skip_white_space
         collect_to_delimiter
         if next_token.count = 0 
         -- sitting immediately on a delimiter
         then
            next_token.extend(current_char)
            get_next_char
            if in(current_char,delimiters) 
               -- 2 delimiters may be a special token
            then
               next_token.extend(current_char)
               if terminals.find(next_token) > 0
               then
                  get_next_char -- consume this char
               else
                  next_token := next_token.substring(1,1)
               end -- if
            end -- if
         end -- if
         if equal(next_token,".")
         then
            from
            until
               not in(current_char,"0123456789") or eof
            loop
               next_token.extend(current_char)
               get_next_char
            end
         end -- if
         if is_a_terminal(next_token)
         then
            -- this is a keyword
            token_type := terminals.find(next_token)
         else
            -- this is not a keyword
            -- work out what it is
            token_type := Lex_id
         end -- if
      end

    token_type : INTEGER

    alphabet : STRING is "abcdefghijklmnopqrstuvwxyz"

    -- Alteration - Neil Wilson, July 10, 1993
    -- Error handling changed

   error(s : STRING) is
      local
      	 temp: STRING;
      do
         temp := clone(", at line ");
	 temp.append (i2s ("1.0", current_line));
	 s.prepend ("Lexical Error: ");
	 s.append (temp); 
         raise("Lexical Error",s,1,void)
      end

   warning(s : STRING) is
   local
   	temp: STRING;
      do
         temp := clone(", at line ");
	 temp.append (i2s ("1.0", current_line));
         s.prepend ("Warning: ")
	 s.append (temp); 
         io.putstring(s)
         io.new_line  
      end

     -- end of alteration.

   is_a_terminal(s : STRING) : BOOLEAN is
      do
         Result := terminals.find(s) > 0
         debug
            io.putstring(s)
            io.putint(terminals.find(s))
         end
      end

end -- class LEXICAL     
