class LEX_PDL

-- a lexical analyser for Eiffel/S PDL Files



inherit

   LEXICAL_PDL_CONSTANT

   LEXICAL

      rename

         make as lex_make

      redefine

         get_next_token

      end

   

creation

   make



feature

 

   make is

      do

        lex_make

      end

 

   comment_start : STRING is

      once

         Result := "--"

      end



   get_next_token is

      -- gets the next token sets up all other required details

      do

         next_token := ""         

         token_type := 0

         skip_white_space

         collect_to_delimiter

         if next_token.count = 0 

         -- sitting immediately on a delimiter

         then

            next_token.extend(current_char)

            get_next_char

            if in(current_char,delimiters) 

               -- 2 delimiters may be a special token

            then

               next_token.extend(current_char)

               if is_a_terminal(next_token)

               then

                  get_next_char -- consume this char

               else

                  next_token := next_token.substring(1,1)

               end -- if

            end -- if

         end -- if

         if is_a_terminal(next_token)

         then

            -- this is a keyword

            token_type := terminals.find(next_token)

            if token_type=Plex_bracket

            then

               process_flags

            end -- if

         else

            -- this is not a keyword

            -- work out what it is

            inspect next_token.item(1)

               when '%"' then process_string

               when 'A'..'Z','a'..'z' then process_id

               else token_type := Plex_error

            end -- inspect

         end -- if

      end



    process_flags is

       do

          from

             token_type := Plex_flag

          until

             current_char=')'

          loop

             next_token.extend(current_char)

             get_next_char

          end

          next_token.extend(')')

          get_next_char

       end -- process_flags



    process_string is

       local

          prevch : CHARACTER

       do

          from

             token_type := Plex_string

          until

             current_char='%"' or 

             current_char='%N' or eof

          loop

             next_token.extend(current_char)

             prevch := current_char

             get_next_char

             if current_char='%N' and prevch='%%'

             then

                skip_white_space

                if current_char /='%%'

                then

                   token_type := Plex_error

                else

                   get_next_char

                end -- if

             elseif current_char ='%"' and prevch = '%%'

             then

                next_token.extend(current_char)

                prevch := current_char

                get_next_char

             end  -- if

          end -- loop

          next_token.remove(1)

          get_next_char

       end

       

    process_id is

       local

          i : INTEGER

          b : BOOLEAN

       do

          b := true

          from

             i := 1

          until

             i > next_token.count or else not in(next_token.item(i),Alphanum)

          loop

             i := i + 1

          end

          if b and in(next_token.item(1),alphabet)

          then

             token_type := Plex_id

          else

             token_type := Plex_flag

          end -- if

       end



   Alphanum : STRING is

      once

         Result := clone(alphabet)

         Result.append("0123456789_")

      end



    create_lex is 

       do

          add_terminal("all",Plex_all)

          add_terminal("as",Plex_as)

          add_terminal("cluster",Plex_cluster)

          add_terminal("end",Plex_end)

          add_terminal("exclude",Plex_exclude)

          add_terminal("find",Plex_find)

          add_terminal("for",Plex_for)

          add_terminal("hfiles",Plex_hfiles)

          add_terminal("in",Plex_in)

          add_terminal("interface",Plex_interface)

          add_terminal("lib",Plex_lib)

          add_terminal("link",Plex_link)

          add_terminal("make",Plex_make)

          add_terminal("program",Plex_program)

          add_terminal("rename",Plex_rename)

          add_terminal("root",Plex_root)

          add_terminal("use",Plex_use)

          add_terminal("--",-Plex_comment)

          add_delimiter("(",Plex_bracket)

          add_delimiter(":",Plex_colon)

          add_delimiter(",",Plex_comma)

          add_delimiter("-",Plex_minus)

       end



end -- class LEX_EIFFEL

