-- Rewindable Character stream on standard input



indexing

	

	type: user;

	author: "$Author: Neil_Wilson $", "(c) 1993";

	date: "$Date: 1993/06/29 19:53:03 $";

	revision: "$Revision: 1.1 $";

	licence: "GNU Library GPL - see file README.LIB";

	log: 

	-- $Log: rewstdin.e $
	-- Revision 1.1  1993/06/29  19:53:03  Neil_Wilson
	-- Initial revision

	--



class REWINDABLE_STDIN



inherit



	REWINDABLE_CHARACTER_STREAM



creation



	open



feature -- Open stream



	open is

		-- Initialise stream

	do

		!!return_queue.make (0);

		current_line := 1;

		current_char := ' ';

		is_connected := true

		debug

		    io.putstring ("Made queue");

		    io.new_line

		end

	end -- make

	

feature -- Interrogators



	is_marked: BOOLEAN;



	current_char: CHARACTER;



	current_line: INTEGER;



	end_of_stream: BOOLEAN is

		-- Have we reached the end of the stream?

	do

		Result := io.end_of_input and return_queue.empty

	end -- end_of_stream



	is_connected: BOOLEAN

		-- Is stream still accessible?



	next_char: CHARACTER is

		-- Peek at next character in stream

	do

		if end_of_stream then

			Result := '%N'

		elseif return_queue.empty then

			io.readstring

			return_queue.append (io.laststring)

			return_queue.extend ('%N')

			if is_marked then

				mark_queue.append (io.laststring)

				mark_queue.extend ('%N')

			end

		else

			Result := return_queue.item (1);

		end

		debug

			io.putstring ("Next character: ");

			io.putchar (Result)

			io.new_line

		end;

	end -- next_char



feature -- Stream rewind facilities



	mark is

		-- Hold stream characters in mark queue.

	do

		marked_char := current_char

		marked_line := current_line

		is_marked := true;

		mark_queue := clone (return_queue)

	end -- mark



	return is

		-- Place the marked characters in the return queue

	do

		current_char := marked_char

		current_line := marked_line

		is_marked := false

		return_queue := mark_queue

	end -- return



feature -- stream mutilators



	close is 

		-- Prevent further access to stream

	do

		is_connected := false

	end -- close



	get_next_char is

		-- Retrieve next character from stream

	do

		if current_char = '%N' then

			current_line := current_line + 1

		end

		if end_of_stream then

			current_char := '%N';

		else

			if return_queue.empty then

				io.readstring

				return_queue.append (io.laststring)

				return_queue.extend ('%N')

				if is_marked then

					mark_queue.append (io.laststring)

					mark_queue.extend ('%N')

				end

			end

			current_char := return_queue.item (1)

			return_queue.remove (1)

		end

		debug

			io.putstring ("Get Next character is ");

			io.putchar (current_char)

			io.new_line

		end;

	end -- get_next_char	



feature {NONE} -- Rewind implementation features



	marked_char: like current_char

		-- Copy of the marked 'current_char'



	marked_line: like current_line

		-- Copy of the marked 'current_line'



	mark_queue: like return_queue

		-- Holds the rewindable characters



	return_queue: STRING

		-- Rewound characters



invariant



	return_queue_available: return_queue /= Void



	sensible_line_number: current_line > 0

	

end -- class REWINDABLE_STDIN

