-- Rewindable Character stream from a file

indexing
	
	type: user;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/08/01 13:33:35 $";
	revision: "$Revision: 1.3 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: rew_file.e $
	-- Revision 1.3  1993/08/01  13:33:35  Neil_Wilson
	-- Corrected assertion violation in get_nect_char
	--
	-- Revision 1.2  1993/07/01  20:10:30  Neil_Wilson
	-- Corrected inconsistent invariant clause
	--
	-- Revision 1.1  1993/06/29  19:53:03  Neil_Wilson
	-- Initial revision
	--

class REWINDABLE_FILE

inherit

	REWINDABLE_CHARACTER_STREAM

	STORAGE_DEVICES

creation

	open

feature -- Open stream

	open (filename: STRING) is
		-- Initialise stream
	require
		fs.has_readperm (filename)
	do
		!!rewfile.connect_to (fs.access_file (filename, "r", false))
		current_place := 0
		current_line := 1;
		current_char := ' ';
		buffer := rewfile.item_range (1,
		    min (block_size, rewfile.count))
		debug
		    io.putstring ("Made connection");
		    io.new_line
		end
	ensure
		is_connected: rewfile.is_connected
	end -- make
	
feature -- Interrogators

	is_marked: BOOLEAN;

	current_char: CHARACTER;

	current_line: INTEGER;

	end_of_stream: BOOLEAN;
		-- Have we reached the end of the stream?

	is_connected: BOOLEAN is
		-- Is the stream connected
	do
		Result := rewfile.is_connected
	end -- is_connected

feature -- Stream rewind facilities

	mark is
		-- Hold stream characters in mark queue.
	do
		marked_place := current_place
		marked_char := current_char
		marked_line := current_line
		marked_eof := end_of_stream
		is_marked := true;
	end -- mark

	return is
		-- Place the marked characters in the return queue
	do
		current_place := marked_place
		current_char := marked_char
		current_line := marked_line
		end_of_stream := marked_eof
		is_marked := false
	end -- return

feature -- stream manipulators

	close is
		-- Close the stream
	do
		rewfile.disconnect
	end -- close

	get_next_char is
		-- Retrieve next character from stream
	do
		if current_char = '%N' then
			current_line := current_line + 1
		end
		if not end_of_stream then
		    debug
		    	io.putbool (end_of_stream)
			io.new_line
		    end
		    current_place := current_place + 1
		end
		if buffer.lower <= current_place and then 
		    current_place <= buffer.upper then
			current_char := buffer.item (current_place)
		elseif current_place <= rewfile.count then
			buffer := rewfile.item_range (current_place, 
			    min (current_place + block_size, rewfile.count))
			current_char := buffer.item (current_place)
		else
			end_of_stream := true
			current_char := '%N'
		end
		debug
			io.putstring ("Get Next character is ");
			io.putchar (current_char)
			io.new_line
		end;
	ensure then
		eof_condition: current_place > rewfile.count implies
		    (end_of_stream and current_char = '%N')
		buffer_available: (current_place <= rewfile.count) implies
		    not buffer.empty
	end -- get_next_char	

	next_char: CHARACTER is
		-- Peek at next character in stream
	do
		if buffer.lower <= current_place + 1 and then
		    current_place < buffer.upper then
			Result := buffer.item (current_place + 1)
		elseif current_place < rewfile.count then
			buffer := rewfile.item_range (current_place + 1, 
			    min (current_place + block_size, rewfile.count))
		else
			Result := '%N'
		end
		debug
			io.putstring ("Next character: ");
			io.putchar (Result)
			io.new_line
		end;
	ensure then
		file_pointer_stable: current_place = old current_place
		buffer_available: (current_place < rewfile.count) implies
		    not buffer.empty
	end -- next_char

feature {NONE} -- Rewind implementation features

	rewfile: FILE [CHARACTER]
		-- Source of the character stream

	buffer: ARRAY [CHARACTER]
		-- Buffers the 'rewfile'

	block_size: INTEGER is 1024
		-- Size of range reads from 'rewfile'

	current_place: INTEGER
		-- A 'pointer' to the current part of the character stream

	marked_char: like current_char
		-- Copy of the marked 'current_char'

	marked_line: like current_line
		-- Copy of the marked 'current_line'

	marked_place: like current_place
		-- Copy of the marked 'current_place'

	marked_eof: like end_of_stream
		-- Copy of the marker 'end of stream'

	min (a, b: INTEGER): INTEGER is
		-- Minimum of A and B
	do
		if A < B then
			Result := A
		else
			Result := B
		end
	end -- min

invariant

	character_stream_available: rewfile /= Void 
	
	sensible_line_number: current_line > 0

	pointer_positive: rewfile.is_connected implies current_place >= 0
	pointer_range: rewfile.is_connected implies (current_place <= rewfile.count + 1)

	buffer_available: buffer /= Void
	
end -- class REWINDABLE_STDIN
