-- Stream of characters with the ability to go back on the input.



indexing

	

	type: abstract;

	author: "$Author: Neil_Wilson $", "(c) 1993";

	date: "$Date: 1993/06/29 19:53:03 $";

	revision: "$Revision: 1.1 $";

	licence: "GNU Library GPL - see file README.LIB";

	log: 

	-- $Log: rew_strm.e $
	-- Revision 1.1  1993/06/29  19:53:03  Neil_Wilson
	-- Initial revision

	--



deferred class REWINDABLE_CHARACTER_STREAM



feature -- Stream interrogators



	end_of_stream: BOOLEAN is

		-- Are we at the end of the character stream?

	require

		connected: is_connected

	deferred

	end -- end_of_stream



	current_line: INTEGER is

		-- Count of newlines in the character stream

	deferred

	end -- current_line



	current_char: CHARACTER is

		-- Last character retrieved by 'get_next_char'

	deferred

	end -- current_char



	is_marked: BOOLEAN is

		-- Is there a mark current in the character stream?

	deferred

	end -- is_marked



	is_connected: BOOLEAN is

		-- Is the stream hooked up to some characters?

	deferred

	end -- is_connected



	next_char: CHARACTER is

		-- The next character on the input stream

	require

		connected: is_connected

	deferred

	ensure

		current_line = old current_line

		end_of_stream = old end_of_stream

		current_char = old current_char

		next_char = old next_char

		handle_end_stream: end_of_stream implies next_char = '%N'

	end -- next_char



feature -- Stream mutilators



	close is

		-- Prevent further access to the stream

	deferred

	ensure

		disconnected: not is_connected

	end -- close

	

	get_next_char is

		-- Retrieve next character from stream

	require

		connected: is_connected

	deferred

	ensure

		handle_end_stream: old end_of_stream implies current_char = '%N'

		old current_char = '%N' implies current_line = old current_line + 1

		current_char = old next_char

	end -- get_next_char



	mark is

		-- Place a marker in the stream

		-- Previous markers are discarded

	require

		connected: is_connected

	deferred

	ensure

		mark_announced: is_marked

	end -- mark



	return is

		-- Go back in the stream to the mark 

	require

		connected: is_connected

		mark_placed: is_marked

	deferred

	ensure

		mark_removed: not is_marked

	end -- return



end -- class REWINDABLE_CHARACTER_STREAM

