
indexing

	date: "$Date: 1993/07/18 15:26:05 $";
	revision: "$Revision: 1.1 $";
	log: 
	-- $Log: set.e $
	-- Revision 1.1  1993/07/18  15:26:05  David_Morgan
	-- Initial revision
	--

class SET[G]
-- A class to represent sets

feature

   in(x : G) : BOOLEAN is
   -- set membership
      local 
         i : INTEGER
      do
         from
            i := elements.lower
         until
            i > elements.upper
            or else Result
         loop
            Result := equal(x,elements.item(i))
            i := i + 1
         end
      end

   add(x : G) is
   -- addition of an element
      do
         if elements = Void
         then
            !!elements.make(1,1)
            elements.put(x,1)
            count := 1
         elseif not in(x)
         then
            count := count + 1
            elements.force(x,count)
         end -- if
      ensure
         in(x) 
      end -- add

   subtract (x : G) is
   -- subtraction of an element
      local
         i : INTEGER
      do
         if count > 0
         then
            from
               i := elements.lower
            until
               i > count or else equal(x,elements.item(i))
            loop
               i := i + 1
            end  -- loop
            if i <= count
            then
               elements.remove(i)
               count := count - 1
            end -- if
         end -- if
      ensure
         not in(x)
      end -- subtract

   empty : BOOLEAN is
   -- an empty set
      do
         Result := count = 0
      end

   union (other : like Current) is
   -- combine two sets
      local
         i : INTEGER
      do 
         if not other.empty
         then
            from
               i := other.elements.lower
            until
               i > other.count
            loop
               add(other.elements.item(i))
               i := i + 1
            end -- loop 
         end-- if
      ensure
         -- forall x in other : in(x)
      end -- union

   count : INTEGER
   -- the arity of the set

   finished : BOOLEAN is
   -- at the end of a traversal of the set
      do
         Result := cursor > count
      end

   start is
   -- start the traversal
      do
         cursor := elements.lower
      end

   forth is
   -- move forward in the traversal
      do
         cursor := cursor + 1
      end

   back is
   -- go back in the traversal
      do
         cursor := cursor - 1
      end

   item : G is
   -- the current place in the traversal
      require
        not finished
      do
         Result := elements.item(cursor)
      end

feature {SET}

   elements : ARRAY[G]
   -- the elements of the set

feature {NONE}

   cursor : INTEGER
   -- a place for the traversal

end -- class SET
