class SLLIST[G->COMPARABLE] 
-- a sortable singly linked list 

inherit
   LLIST[G]
      redefine
         append,insert,put
      end

creation
   make

feature

   put( x : G) is
      local
         t,l : LINK[G]
      do
         if count = 0
         then
            !!l.make(x)
            first_elem := l
            last_elem := l
            cursor := l
            off_left := false
            off_right := false
         else
            if x < first_elem.item
            then
               !!l.make(x)
               l.connect_next(first_elem)
               first_elem := l
            else
               from
                  start
               until
                  cursor.next = Void or else cursor.next.item > x
               loop
                  forth
               end -- loop
               add_right(x)
            end -- if
         end -- if
         count := count + 1
      end

   insert, append( other : like Current) is
     do
        from
           other.start
        until
           other.off_right
        loop
           put(other.item)
           other.forth
        end
     end

end -- class SLLIST
