class VERSION
-- a normalised feature (semi flattened)

inherit
   COMPARABLE
   ANY
      redefine
         copy,
         is_equal
      end
      
creation
   make

feature

   feature_name : EIFFEL_FEATURE_NAME

   exports : EIFFEL_CLIENTS

   result_type : EIFFEL_TYPE

   formals : LLIST[EIFFEL_ENTITY_DECLARATION]

   routine : EIFFEL_ROUTINE

   featurec : EIFFEL_TOKEN

   constant : EIFFEL_MANIFEST_CONSTANT

   uniq : EIFFEL_TOKEN

   set_export(c : EIFFEL_CLIENTS) is
      do 
         exports := clone(c)
      end

   supplier_classes : SET[STRING] is
      do
         !!Result
         if result_type /= Void
         then
            Result.union(result_type.supplier_classes)
         end
         if formals /= Void
         then
            from
               formals.start
            until
               formals.off_right
            loop
               Result.union(formals.item.supplier_classes)
               formals.forth
            end
         end -- if
         if routine /= Void
         then
            Result.union(routine.supplier_classes)
         end
      end

   make(fn : EIFFEL_FEATURE_NAME; fl : LLIST[EIFFEL_ENTITY_DECLARATION];
        rt : EIFFEL_TYPE; rn : EIFFEL_ROUTINE;
        cn : EIFFEL_MANIFEST_CONSTANT; fc : EIFFEL_TOKEN; un : EIFFEL_TOKEN)
   -- make a normalised feature
      is
      do
         feature_name := fn
         result_type := rt
         formals := fl
         routine := rn
         constant := cn
         featurec := fc
         uniq := un
      end

   infix "<" (other : like Current) : BOOLEAN is
      do
         if exports = Void
         then
            if other.exports = Void or else other.exports.contains("ANY")
            then
               Result := feature_name < other.feature_name
            else -- this is void ==> ANY and the other isn't ANY/Void
               Result := true
            end 
         elseif other.exports = Void or else other.exports.contains("ANY")
         then
            Result := false
         elseif exports.contains("NONE")  -- not void and not ANY
         then
            Result := false
         elseif other.exports.contains("NONE")
         then
            Result := true
         else
            Result := exports < other.exports and then
                     feature_name < other.feature_name
         end -- if        
      end

  -- Alteration - Neil Wilson, July 17, 1993
  -- Altered formatter type.

   flat, short(f : EIFFEL_FORMAT) is
      do
         f.new_line
         f.keyword_write("feature")
         if exports /= Void
         then
            f.space
            exports.short(f)
         end
         f.increase_indent
         f.new_line
         feature_name.short(f)
         f.space
         if formals /= Void
         then
            f.normal_write("(")
            from
               formals.start
               formals.item.short(f)
               formals.forth
            until
               formals.off_right
            loop
               f.normal_write(";")
               f.space
               formals.item.short(f)
               formals.forth
            end
            f.normal_write(")")
            f.space
         end
         if result_type /= Void
         then
            f.normal_write(":")
            f.space
            result_type.short(f)
         end
         if featurec /= Void
         then
            f.increase_indent
            f.new_line
            featurec.short(f)
            f.decrease_indent
         end
         if routine /= Void 
         then
            routine.short(f)
         end
         f.decrease_indent
         f.new_line
      end
      
   copy(other : like Current) is
      do
         feature_name := clone(other.feature_name)
         exports := clone(other.exports)
         result_type := clone(other.result_type)
         formals := clone(other.formals)
         routine := clone(other.routine)
         featurec := clone(other.featurec)
         constant := clone(other.constant)
         uniq := clone(other.uniq)
      end
      
   is_equal(other : like Current): BOOLEAN is
      do
         Result := 
            equal(feature_name, other.feature_name) and then
            equal(exports,other.exports) and then
            equal(result_type, other.result_type) and then
            equal(formals, other.formals) and then
            equal(routine, other.routine) and then
            equal(featurec, other.featurec) and then
            equal(constant, other.constant) and then
            equal(uniq, other.uniq)
      end
      
end -- class EIFFEL_NORMAL_FEATURE
