Black mask is an alpha version of an OODBMS to be used with Eiffel. Currently,
it consists only of a single class BANY, which implements all of the needed
functionality to establish an OODB. This OODBMS creates and uses dBase
compatible data files, only the index files are not compatible. There are
still some bugs and missing features (the iterator stuff works, but not the
way it should !), but black mask makes it possible to implement an OODB
without to much effort. This alpha release serves only as a demonstration
for a general principle (which is not very easy to implement, but easy to use).

BASIC CONCEPTS:

I recommend reading Richie Bielak's eccelent article series in Eiffel Outlook
(Vol. 2, No. 4 and No. 5, Vol. 3 No. 1), which gives a short but good
introduction to the principles and problems creating an OODBMS. Much of his
ideas can be found in black mask too, although I first had a different approach.
My first idea was to make the persistence of objects totally invisible to
the programmer, who only should decide which objects will be persistent. This
means that the runtime system has to take care of where the objects are, either
in memory or on persistent storage, and has to fetch them accordingly.
Since all objects are attributes of other objects, they will be accessed by
usual attribute declarations and modified by some modification procedures.
This is the hook where a OODBMS could start its work. Persistent attributes
generate an access and modification function, but this is transparent to the
programmer. Even very big objects (with regards to structural complexity) can
be handled, because the needed attributes are only fetched from persistent
storage when they are accessed. Otherwise, only an ID will point to the
place where they can be found.
But all this is only theory. In reality, this approach fails due to many
reasons: The transparent access to persistent attributes is a compiler and
runtime system issue, to which I do not have access. The performance of
such a system should be close to inacceptable for time critical applications.
The question of where to store the code which the persitent objects
obviously need to be created and to operate is not clear. Should it be in
the application program, thus making Eiffel the DDL and DML ? Should it be
in some kind of server ?
After encountering so many problems, I put the project aside, until I read
Richie Bielak's articles. I saw many of the ideas I had, and possible
solutions too. The only problem was the availability of his system. He
uses Versant as an underlying DBMS, which is a big cost factor. So I decided
to implement a free version of an OODBMS, which represents a mixture of
ideas of different origin. Its base is an relational DBMS (creating this
is another story, it still is not perfect yet, consider it alpha software).
On top of this sits the one and only class in this cluster, BANY. It
allows the programmer to implement persistent objects.
This project is not even half-begun, so you should take a look at the sample
code (BTEST, BTEXT). Further documentation will follow. Any comments are
welcome !

Software Services Koeppen
Im Spring 13
42555 Velbert
Germany

koeppen@hp06c.informatik.uni-essen.de

