This is the secon implementation of an interface to the Athena Widget Set.
There have been several changes, improvements and bug fixes, though I would
still consider it a beta release, since some constructs appear not clean enough
to me, and there are many things which haven't been implemented yet.
The classes should work under both X11R4 and X11R5. Currently, I use them
under XFree86 1.3, running on a 386/33, 20 MB, with Esix 4.0.3a, and there
are almost no problems, neither stability or performance.

BASIC CONCEPTS:

This class collection represents a subset of the Athena Widget Set. Anybody
familiar with this widget set should have no problems using the classes,
since their functionality resembles very much the Athena Widgets. An
application usually consists of a main class which creates an object of
the class XTOPLEVEL. This object serves as the parent object for any other
user interface object in the application. At object creation time, the
objects are assigned a parent object, and the toplevel object is the topmost
object in the whole application. It contains the event processing loop,
which can be terminated only through a call to 'set_finished'.
For a more detailed example, you should look at hipnotic, which is an
interface to the Eiffel/S compiler. It makes use of almost any implemented
widget. The use of event handlers (classes XCALLER, XCALLABLE, XEVENT)
resembles the X approach, but more detailed information on how to
implement an application that handles events should follow in one of the next
releases.

PROBLEMS:

A very big problem arises with the educational version of Eiffel/S.
It allows only up to 75 classes in an application, and this makes it
extremely difficult to implement large class hierarchies such as a widget set.
Anyway, the supposed 75 classes melt down to 30 to 50, if you consider the
large amount of Eiffel/S library classes. I think this is a point SiG
should definitly change, so that an educational systems can have up to
75 classes *netto* !
Changing the resources of a widget may not work or only before the widget 
gets realized. Some resources don't even make sense but it is possible to 
change them like the X and Y resource which works only with shell widgets. 
The programmer should have some knowlegde on how the Athena widgets work 
to understand why certain things work and some others don't.
The documenation is thus a little weak because I didn't want to give an
introduction to the Athena widgets, but since I'm still working on this
project, this may change in the future.
Other problems concern the memory management. Using Eiffel/S 1.0, the
RMM_alloc, RMM_free and RMM_realloc functions seemed to work improperly. 
There are no problems with Eiffel/S 1.2, but I am still not sure if for 
example the XLIST class doesn't contain some severe memory leaks. The 
process image file in the /proc directory gets bigger and bigger during 
program execution, but I do not have the tools or the time to track this 
memory leakage.
The implementation of the XCOMMAND class was made without using the
$ operator. This operator can always be avoided in an OO language, though
it may be a little tricky. It is more a question of how to design a class
hierarchy. I implemented the callback mechanism using INTEGERS to
distinguish the different events, although this leads to inspect ... when
instructions. But when designing a class hierarchy, it is IMHO no good
style to let the structure of the objects influence the hierarchy of the
classes, which would happen if any button in the program would have to
inherit from XCOMMAND and redefine the callback feature. This is ok if
the goal is to design a single program, but it is problematic if one has
to design a class hierarchy which is meant to cover only general cases. Here,
it is still possible to chose the inheritance approach, but the event code
is the preferred method.

CHANGES:

A major change has taken place concerning canvases and bitmaps/pixmaps.
I dropped the idea of having a backing-store pixmap to draw on, of which
parts are copied to the actual window as exposure events occur. Although
this approach gives significantly better performance, there is a problem
in allocation large pixmaps and not being able to free them, since the
garbage collector doesn't call an object specific clean-up procedure which
could do this. So if an application needs to draw on some kind of canvas,
it should implement an event handling object (inheriting from XCALLABLE),
and enable the exposure event handler of this object. This event handler
now has to take care of the drawing process. It is for example possible
to extract the extents of the exposed region from the exposure event and
to draw only the exposed region. On the other hand, it is also possible
to redraw the whole image (preferrably if the exposure event is the last
event, i.e. 'count' is 0).
There have been some minor changes with the use of STYLES, they don't need
a XCANVAS object as a partner any more.
I'm sure there are some other small changes which will affect programs
written with an earlier release of this class collection, but this
project is still in a beta phase and the changes were almost inevitable.
Anyway, any error corrections and improvements are welcome.

TODOS:

many ... (menus, bug fixes, documentation, and so on)

Software Services Koeppen
Im Spring 13
42555 Velbert
Germany

koeppen@hp06c.informatik.uni-essen.de

