class TEXT_METRICS
inherit
   EXTERNAL_STRUCTURE
   redefine
      size
   end
creation
   make
-----------------------------------------------------------------------------
feature { WINDOW }
   ---------------------------------------------------- height
   height : INTEGER is
   require
--      store /= Void;
   do
      Result := get_integer( store, api.TextMetrics_tmHeight );
	end;
	---------------------------------------------------- width
	width : INTEGER is
	require
--      store /= Void;
	do
		Result := get_integer( store, api.TextMetrics_tmMaxCharWidth );
	end;
-----------------------------------------------------------------------------
feature --{ NONE }
	---------------------------------------------------- make
	make( hdc : INTEGER ) is
	require
		valid_context : hdc /= 0;
	local
		ok : BOOLEAN;
		p  : POINTER;
	do
		protect( Current );
		p := allocate( size );
		store := p;
		ok := api.GetTextMetrics( hdc, store );
		if NOT ok then
			free;             -- arise postcondition
		end;
	ensure
		store /= Void;
	end;

	---------------------------------------------------- size
	size : INTEGER is
	once
		Result := api.TextMetrics_sizeof;
	ensure then
		positive : Result > 0;
	end;
end;
