class WINDOWS_CONSOLE
inherit
   WINDOW
   redefine
      title,
      setup,
      init_wddvt,
      paint
   end;
   FORMAT;
creation
   create
feature
   ---------------------------------------------------- title
   title : STRING is
   do
      put_string( "Console.title" );
      put_newline;
      !!Result.adapt("Class: WINDOWS_CONSOLE");
   end;
   ---------------------------------------------------- setup
   setup() is
   do
      put_string( "Console.Setup" );
      put_newline;
      !!list.make( false );    -- empty array
   end;
   ---------------------------------------------------- init_wddvt
   init_wddvt is
   do
      put_string( "Console.init_wddvt" );
      put_newline;
      !!wddvt.make( true );
      wddvt.add( hacker.p2i( $on_char ), api.wm_Char )

   end;
   ---------------------------------------------------- paint
   paint() is
   local
      text_metrics    : TEXT_METRICS;

      screen_width    : INTEGER;
      screen_height   : INTEGER;
      char_width      : INTEGER;
      char_height     : INTEGER;

      pos_x_on_screen : INTEGER;
      pos_y_on_screen : INTEGER;

      splited_list    : like list;

      start_line_in_list : INTEGER;

      str             : STRING;
      ok              : BOOLEAN;
      it              : ITERATOR;
      i               : INTEGER;
      save_bk_mode    : INTEGER;
      save_font       : INTEGER;
   do
                                             -- prepare display context
      save_bk_mode  := api.SetBkMode( context, api.Transparent );
      save_font     := api.SelectObject(
                              context,
                              stock.proportional_font.to_integer );

      !!text_metrics.make( context );
      char_width    := text_metrics.width;
      char_height   := text_metrics.height;
      text_metrics.free;
      text_metrics  := Void;    -- prevent any issuse after deallocation

      screen_width  := rect.w // char_width;
      screen_height := rect.h // char_height;

      if ( screen_height + 1 ) * char_height > rect.h  then
         screen_height := screen_height - 1;
      end;

--      splited_list := split_lines_in_list( list, screen_width );

      splited_list := clone( list );

      start_line_in_list := splited_list.count - screen_height;

      if start_line_in_list  <= 0 then
         start_line_in_list := 1;
      end;

      from
         i := 1;
         it := splited_list.iterator;
         pos_x_on_screen := 3;
         pos_y_on_screen := 0;
      until
         it.finished;
      loop
         if i >= start_line_in_list  then
            str := splited_list.item( it );
            ok := api.TextOut( context,
                              pos_x_on_screen,
                              pos_y_on_screen,
                              str.to_external,
                              str.count );
            pos_y_on_screen := pos_y_on_screen + char_height;
         end; -- if
         it.forth;
         i := i + 1;
      end; -- loop
      it.stop;
   end;
-----------------------------------------------------------------------------
feature { ANY }
   ---------------------------------------------------- clear_screen
   clear_screen() is
   do
      !!list.make( false );
      update_screen;
   end;
   ---------------------------------------------------- put_string
   put_string( s : STRING ) is
   do
      if NOT wait_for_input then
         put_string_internal( s );
      end; -- if
   end;
   ---------------------------------------------------- put_newline
   put_newline() is
   do
      if NOT wait_for_input then
         put_newline_internal();
      end; -- if
   end;
   ---------------------------------------------------- put_int
   put_int( i : INTEGER ) is
   local
      f : FORMAT;
   do
      !!f;
      put_string( f.i2s( "8.6", i ) );
   end;
   ---------------------------------------------------- put_real
   put_real( r : REAL ) is
   local
      f : FORMAT;
   do
		!!f;
      put_string( f.r2s( "10.6", r ) );
   end;
   ---------------------------------------------------- put_bool
   put_bool( b : BOOLEAN ) is
   local
      f : FORMAT;
   do
      !!f;
      put_string( f.b2s( b ) );
   end;
   ---------------------------------------------------- put_char
   put_char( c : CHARACTER ) is
   local
      f : FORMAT;
   do
      !!f;
      put_string( f.c2s( c ) );
   end;
   ---------------------------------------------------- protect
	protect is
   do
      protected := true;
   end;
   ---------------------------------------------------- realise
   realise is
   do
      protected := false;
   end;
   ---------------------------------------------------- get_string
   get_string( w : WINDOW ) : STRING is
   local
		i  : INTEGER;
		ok : BOOLEAN;
		p  : POINTER;
	do
--      ok := api.EnableWindow( w.handle, false );
		wait_for_input := true;
		ok := api.ShowWindow( handle, api.sw_Normal );
		api.InvalidateRect( handle, p, true );
		!!buffer.adapt("");
		i := get_value( handle );
      !!Result.adapt( buffer  );
      ok := api.ShowWindow( handle, api.sw_Restore );
      wait_for_input := false;
--      ok := api.EnableWindow( w.handle, true );
   end;
   --
   get_value ( h : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_GetValue"
   end;

feature { NONE }
   protected      : BOOLEAN;
   wait_for_input : BOOLEAN;
   ---------------------------------------------------- put_string_internal
   put_string_internal( s : STRING ) is
   local
      str : STRING;
		it  : ITERATOR;
		i   : INTEGER;
      last: STRING;
   do
      if list /= Void AND THEN s /= Void then
         from
            it := list.iterator;
         until
            it.finished;
         loop
            last := list.item( it );
            it.forth;
         end; -- loop

         if last /= Void then
            last.append( s );
            update_screen;
         end; -- if
      end;
   end;
	---------------------------------------------------- put_char_internal
	put_char_internal( c : CHARACTER ) is
   local
      f : FORMAT;
   do
      !!f;
      put_string_internal( f.c2s( c ) );
   end;
   ---------------------------------------------------- put_newline_internal
   put_newline_internal() is
   do
      if list /= Void then
         list.add( "" );
      end;
      update_screen;
   end;
   ---------------------------------------------------- update_screen
   update_screen is
   local
      p : POINTER;
	do
		api.InvalidateRect( handle, p , true );
      if NOT protected then
         api.UpdateWindow( handle );
      end; -- if
   end;
   ---------------------------------------------------- buffer
   buffer : STRING;
   ---------------------------------------------------- list
   list : LIST [ STRING ];
   ---------------------------------------------------- split_lines_in_list
   split_lines_in_list( lst : like list, max : INTEGER ) : like list is
   local
      i : INTEGER;   -- current line in "lst"
      j : INTEGER;   -- current line in "Result"
      s : STRING;
      it: ITERATOR;

   do
      !!Result.make( false );
		from
         it := list.iterator;
      until
         it.finished;
      loop
         if lst.item( it ) /= Void  then
            s.adapt( lst.item( it ) );
            from
            until
               s.count <= max;
            loop
               Result.add( s.substring(1,max) );
               s.adapt( s.substring( max+1, s.count ) );
            end; -- loop
            Result.add( s );
         end; -- if
      end; -- loop
      it.stop;
   end;
   --
   on_char( msg : MESSAGE ) is
   local
      ch : CHARACTER;
      ok : BOOLEAN;
   do
      if wait_for_input then
         ch := msg.char;
         inspect
            ch;
         when '%/32/'..'%/32/', 'A'..'Z', 'a'..'z', '0'..'9'  then
            buffer.extend( ch );
            put_char_internal( ch );
         when '%R' then -- ENTER 0x0D
            ok := api.PostMessage( handle, api.wm_Quit, 0, 0);
         else
            -- nothing
         end;
      end; -- if

   end;
end; -- WINDOWS_CONSOLE

