#include "windows.h"
#include "eiffel.h"
#include "ext_st.h"
POINTER ext_deallocate( POINTER p )
{
  if ( p != NULL )
    OS_free( p );
  p = VOIDREF;
  return p;
}
POINTER ext_allocate( INTEGER size )
{
  POINTER p;
  p = OS_alloc( size );
  if ( p == NULL )
     p = VOIDREF;
  return p;
}
void ext_protect ( OBJREF obj )
{
  RTMM_protect( &obj, 1 );
}
void ext_unprotect ( OBJREF obj )
{
  RTMM_unprotect( &obj );
}
INTEGER ext_getValue( POINTER p, INTEGER index )
{
  INTEGER rc;

  typedef union tagGENERIC {
	 LPTEXTMETRIC  tm;
	 LPPAINTSTRUCT ps;
	 LPRECT        rc;
	 LPPOINT       pt;
	 LPSIZE        sz;
	 LPSTR         p;
  } GENERIC;
  typedef GENERIC far * LPGENERIC;

  GENERIC g;

  g.p = p;

  switch( index )
  {
	 case PaintInfo_hdc :
				  rc = g.ps->hdc;
				  break;
	 case PaintInfo_fErase :
				  rc = g.ps->fErase;
				  break;
	 case PaintInfo_rcPaint :
				  rc = (INTEGER) &(g.ps->rcPaint);
				  break;
	 case Rect_x :
				  rc = min(g.rc->left,g.rc->right);
				  break;
	 case Rect_y :
				  rc = (INTEGER)min(g.rc->top,g.rc->bottom);
				  break;
	 case Rect_w :
				  rc = (g.rc->right - g.rc->left);
				  if ( rc <= 0 ) rc = -rc;
				  break;
	 case Rect_h :
				  rc = (g.rc->bottom - g.rc->top);
				  if ( rc <= 0 ) rc = -rc;
				  break;
	 case TextMetrics_tmHeight :
				  rc = (g.tm->tmHeight);
				  break;
	 case TextMetrics_tmMaxCharWidth :
				  rc = (g.tm->tmMaxCharWidth);
              break;
    default :
              rc = 0;
  }
  return rc;
}








