deferred class EXTERNAL_STRUCTURE
-----------------------------------------------------------------------------
feature -- { MANAGER  }
   ---------------------------------------------------- free
   frozen free is
   require
      store /= Void;
   do
      store := deallocate( store );
      unprotect( Current );
--      store := Void;
   ensure
      store = Void;
   end;
   ---------------------------------------------------- to_external
   frozen to_external : POINTER is
   require
      store /= Void;
   do
      Result := store;
   end;
-----------------------------------------------------------------------------
feature -- { NONE }
   ---------------------------------------------------- allocate
   allocate( s : INTEGER ) : POINTER is
   require
      positive   : s > 0;
      inside_64k : s <= 65535;
   external "CWC"
   alias    "ext_allocate"
   ensure
      allocated  : Result /= Void;
   end;
   ---------------------------------------------------- size
   size() : INTEGER is
   deferred
   end;
   ---------------------------------------------------- deallocate
   deallocate( p : POINTER ) : POINTER is
   require
      is_correct : p = store;
      allocated  : p /= Void;
   external "CWC"
   alias    "ext_deallocate"
   end;
   ---------------------------------------------------- get_integer
   get_integer( p : POINTER, index : INTEGER  ) : INTEGER is
   require
--      is_correct : p = store;
--      allocated  : p /= Void;
   external "CWC"
   alias    "ext_getValue"
   end;
   ---------------------------------------------------- get_boolean
   get_boolean( p : POINTER, index : INTEGER  ) : BOOLEAN is
   require
      is_correct : p = store;
      allocated  : p /= Void;
   external "CWC"
   alias    "ext_getValue"
   end;
   ---------------------------------------------------- get_pointer
   get_pointer( p : POINTER, index : INTEGER  ) : POINTER is
   require
      is_correct : p = store;
      allocated  : p /= Void;
   external "CWC"
   alias    "ext_getValue"
   end;
   ---------------------------------------------------- protect
   protect( obj : ANY ) is
   require
      exist : obj /= Void;
   external "CWC"
   alias    "ext_protect"
   end;
   ---------------------------------------------------- unprotect
   unprotect( obj : ANY ) is
   require
      exist : obj /= Void;
   external "CWC"
   alias    "ext_unprotect"
   end;
   ---------------------------------------------------- store
   store : POINTER;
   ---------------------------------------------------- api
   api : API_WINDOWS is
   once
      !!Result.make;
   end;
end -- EXTERNAL_STRUCTURE
