#include "eiffel.h"
#include "windows.h"
#include "STRING.h"

HANDLE g_hInstance;
HANDLE g_hPrevInstance;
int    g_nCmdShow;
LONG   rc=0;
OBJREF  current;

typedef LONG (FAR PASCAL _export *WCALLBACK)(HWND, UINT, WPARAM, LPARAM);
typedef LONG (*WINDOW_CALLBACK)(RTF*,OBJREF,OBJREF);
typedef LONG (*MANAGER_CALLBACK)(RTF*,OBJREF, LONG, LONG, LONG, LONG );

HRGN DrawPanelAndSetClipRgn( HDC hDC, LPRECT rc );
void DrawPercentBar( HDC hDC, LPRECT rc, INTEGER Percent );


WCALLBACK         default_callback;
WCALLBACK         button_callback;
WCALLBACK         listbox_callback;
WCALLBACK         scrollbar_callback;
WCALLBACK         edit_callback;
MANAGER_CALLBACK callback;

LONG FAR PASCAL _export StdWndProc(HWND, UINT, WPARAM, LPARAM );

char *cmdline   [2];
char szExecname [80+1];

int eiffel_run ();
int eiffel_start (int, char**, char**);

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
    WNDCLASS wc;
    // save parameters
    g_hInstance     = hInstance;
    g_hPrevInstance = hPrevInstance;
    g_nCmdShow      = nCmdShow;

    // get program name
    GetModuleFileName (hInstance, szExecname, 80);
    cmdline [0] = szExecname;
    cmdline [1] = NULL;

    // and start program execution

    wc.style          = CS_HREDRAW;
    wc.cbClsExtra     = 0;
    wc.cbWndExtra     = 0;
    wc.hInstance      = g_hInstance;         // ???
    wc.lpfnWndProc    = StdWndProc;   // ???
    wc.hIcon          = 0;
    wc.hCursor        = (HCURSOR)LoadCursor ( 0, IDC_ARROW );
    wc.hbrBackground  = (HBRUSH)GetStockObject (LTGRAY_BRUSH);
    wc.lpszMenuName   = 0;
    wc.lpszClassName  = "EiffelStatusLine";

    rc = RegisterClass (&wc);

    wc.style          = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
    wc.cbClsExtra     = 4;
    wc.cbWndExtra     = 0;
    wc.hInstance      = g_hInstance;
    wc.lpfnWndProc    = StdWndProc;
    wc.hIcon          = LoadIcon ( 0, IDI_APPLICATION );
    wc.hCursor        = LoadCursor ( 0, IDC_ARROW );
    wc.hbrBackground  = GetStockObject (LTGRAY_BRUSH);
    wc.lpszMenuName   = "Eiffel";
    wc.lpszClassName  = "Eiffel";

    rc = RegisterClass (&wc);

    if ( GetClassInfo(NULL, "BUTTON", &wc ) )
    {
      button_callback  = wc.lpfnWndProc;
      wc.hInstance      = g_hInstance;
      wc.lpfnWndProc    = StdWndProc;
       wc.lpszClassName  = "EiffelButton";
       rc = RegisterClass (&wc);

    }
    if ( GetClassInfo(NULL, "LISTBOX", &wc ) )
    {
      listbox_callback  = wc.lpfnWndProc;
      wc.hInstance      = g_hInstance;
      wc.lpfnWndProc    = StdWndProc;
       wc.lpszClassName  = "EiffelListbox";
       rc = RegisterClass (&wc);

    }
    if ( GetClassInfo(NULL, "SCROLLBAR", &wc ) )
    {
      scrollbar_callback  = wc.lpfnWndProc;
      wc.hInstance      = g_hInstance;
      wc.lpfnWndProc    = StdWndProc;
       wc.lpszClassName  = "EiffelScrollbar";
       rc = RegisterClass (&wc);

    }
    if ( GetClassInfo(NULL, "EDIT", &wc ) )
    {
      edit_callback  = wc.lpfnWndProc;
      wc.hInstance      = g_hInstance;
      wc.lpfnWndProc    = StdWndProc;
       wc.lpszClassName  = "EiffelEdit";
       rc = RegisterClass (&wc);

    }

    (VOID) eiffel_start (3, cmdline, cmdline);
    if (eiffel_run () == -1)
            return (FALSE);

    return (0);
}
LONG message_loop ()
{
    MSG msg;

    while (GetMessage (&msg, NULL, NULL, NULL))
    {
       TranslateMessage (&msg);
       DispatchMessage (&msg);
    }
    MessageBeep(0);
    return (msg.wParam);
}
LONG m_register (OBJREF cur, MANAGER_CALLBACK mf)
{
  if ( current != 0 )
     return 0L;
  current  = cur;
  callback = mf;
  return 1L;
}
LONG m_execute (OBJREF w, OBJREF msg, WINDOW_CALLBACK method )
{
  RTF   _cf;
  RTF   _mf;
//#define     RTF_sl(cnt, lc, pf) {pf->next = &_mf; _mf.next = (RTF *) 0; _mf.local_count = (INT16) cnt; _mf.locals = lc; _mf.line = (INT16) 0;}

  RTF_sl(0, (OBJREF *) 0, (&_cf));
  rc = (*method)(&_mf,w,msg);
//#define     RTF_return          {_cf->next = (RTF *) 0;}
//  RTF_return;
  _cf.next = (RTF *) 0;
  return rc;
}
LONG FAR PASCAL _export StdWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{
  RTF   _cf;
  RTF   _mf;
//#define     RTF_sl(cnt, lc, pf) {pf->next = &_mf; _mf.next = (RTF *) 0; _mf.local_count = (INT16) cnt; _mf.locals = lc; _mf.line = (INT16) 0;}
  RTF_sl(0, (OBJREF *) 0, (&_cf));
    rc =  (*callback)(&_mf,current, (INTEGER)hWnd,
            (INTEGER) message,
            (INTEGER) wParam,
            (INTEGER) lParam);

//#define     RTF_return          {_cf->next = (RTF *) 0;}
//  RTF_return;
  _cf.next = (RTF *) 0;
    return rc;

}
long m_default(hWnd, message, wParam, lParam)
INTEGER hWnd;
INTEGER message;
INTEGER wParam;
LONG lParam;
{
    char classname[256];
      GetClassName(hWnd, classname, sizeof(classname));
      if (_fstrcmp(classname,"EiffelButton")==0)
        default_callback = (WCALLBACK)button_callback;
      else if (_fstrcmp(classname,"EiffelListbox")==0)
        default_callback = (WCALLBACK)listbox_callback;
      else if (_fstrcmp(classname,"EiffelScrollbar")==0)
        default_callback = (WCALLBACK)scrollbar_callback;
      else if (_fstrcmp(classname,"EiffelEdit")==0)
        default_callback = (WCALLBACK)edit_callback;
      else
        default_callback = (WCALLBACK)DefWindowProc;
#ifdef __BORLANDC__
     rc = CallWindowProc(((FARPROC)default_callback),
                       (HWND)LOWORD(hWnd),
                       (UINT)LOWORD(message),
                       (WPARAM)LOWORD(wParam),
                       lParam);
#elif
     rc = CallWindowProc(default_callback,
                       (HWND)LOWORD(hWnd),
                       (UINT)LOWORD(message),
                       (WPARAM)LOWORD(wParam),
                       lParam);
#endif
/*
     rc =  (*default_callback) ((HWND)LOWORD(hWnd),
                       (UINT)LOWORD(message),
                       (WPARAM)LOWORD(wParam),
                       lParam);
*/
     return rc;
}
LONG create_window_from_manager ( LONG hParentWnd,
      LPSTR lpszClassName, LPSTR Title, DWORD dwStyle,
      LONG x, LONG y, LONG cx, LONG cy, LONG id )
{
  HANDLE hWnd;
  hWnd = CreateWindow (
       lpszClassName,                                 // class
       Title,                                         // title
       dwStyle,                                       // style
       LOWORD(x), LOWORD(y), LOWORD(cx), LOWORD(cy),  // x,y,cx,cy
       (HWND)LOWORD(hParentWnd),                      // parent
       (HMENU)LOWORD(id),                             // menu / id
       g_hInstance,                                   // inst
       0);                                            // param
  if ( hWnd != 0 )
       ShowWindow (hWnd, /*g_nCmdShow*/SW_SHOWNORMAL);
  return (LONG)hWnd;

}
INTEGER hacker_i2p ( INTEGER i)
{
  return i;
}
INTEGER hacker_p2i ( INTEGER p)
{
  return p;
}
INTEGER hacker_rgb2i ( INTEGER r, INTEGER g, INTEGER b)
{
  return (INTEGER) RGB( LOWORD(r), LOWORD(g), LOWORD(b) );
}
void hacker_protect (OBJREF *obj, INTEGER i)
{
   RGAC_protect ( obj, i);
}
void hacker_unprotect (OBJREF *obj)
{
   RGAC_unprotect ( obj);
}
//**********************  D E F I N I T I O N S  *************************

HRGN DrawPanelAndSetClipRgn( HDC hDC, LPRECT rc );
void DrawPercentBar( HDC hDC, LPRECT rc, INTEGER Percent );

#define STATUSLINE               "StatusLine"

typedef struct tagSTATUSLINE {
   char     Hint[256];
   char     ProgressHint[256];
   char     PosX[20];
   char     PosY[20];
   BOOLEAN  isInProgress;
   INTEGER  UpperLimit;
   INTEGER  CurrentState;
}  STATUSLINESTRUCT;

typedef STATUSLINESTRUCT far * LPSTATUSLINESTRUCT;

//******************************  G L O B A L S ***************************
HPEN     hFacePen, hShadowPen;

//******************************     T E X T    ***************************
void StatusLine_Paint(HWND handle)
{
   HWND hWnd = LOWORD( handle );

   HDC hDC;
   RECT rcClient, rcPanel;
   PAINTSTRUCT ps;
   TEXTMETRIC tm;
   LPSTATUSLINESTRUCT   sl;
   // Fields and proportional font sizes
   int Height, Width, MaxCharWidth;
   int KeyFieldWidth, KeyGroupWidth, xPosWidth, yPosWidth, HintWidth;
   // Window's properties
   BOOLEAN  isInProgress;
   LPSTR    lpszHint, lpszProgressHint, lpszPosX, lpszPosY;
   INTEGER  UpperLimit, CurrentState;
   int      SavedDC;


   // locals
   INTEGER  Percent;
   char     lpszPercent[16];
   int      yTextPos;
   HRGN     hClipRgn;
   COLORREF FaceColor, ShadowColor;

   // get window's property : handle to the STATUSLINE structure
   sl = (LPSTATUSLINESTRUCT)GlobalLock( GetProp( hWnd, STATUSLINE ) );
   hDC = BeginPaint(hWnd,&ps);
   // if status line structure exist start painting
   if ( (sl !=NULL) && (!IsRectEmpty( &( ps.rcPaint ) ) ) )
   {
      lpszHint          = sl->Hint;
      lpszProgressHint  = sl->ProgressHint;
      lpszPosX          = sl->PosX;
      lpszPosY          = sl->PosY;
      isInProgress      = sl->isInProgress;
      UpperLimit        = sl->UpperLimit;
      CurrentState      = sl->CurrentState;
      GetClientRect( hWnd, &rcClient );
      // save display context. It must be restored after use
      SavedDC = SaveDC( hDC );
      // choose proportional font, setup device contextit for text drawing
      SelectObject( hDC, GetStockObject( ANSI_VAR_FONT) );
      SetBkMode( hDC, TRANSPARENT );
      // set text allign. The current posision will be updated automaticaly.
      //                  -------------------------------------------------
      SetTextAlign( hDC, TA_LEFT | TA_TOP | TA_UPDATECP);
      // get text metrics of selected (propotional) font
      GetTextMetrics (hDC, &tm );
      Height         = tm.tmHeight;
      Width          = tm.tmAveCharWidth;
      MaxCharWidth   = tm.tmMaxCharWidth;
      // get system colors for panel shadows
      FaceColor   = RGB(255,255,255);
      ShadowColor = GetSysColor( COLOR_BTNSHADOW );
      // create pens for drawing. (must be deleted after use DeleteObject() )
      hFacePen   = CreatePen( PS_SOLID, 1, FaceColor );
      hShadowPen = CreatePen( PS_SOLID, 1, ShadowColor );
      // the width for aux.. fields
      KeyFieldWidth = 3 * MaxCharWidth;
      xPosWidth = yPosWidth = 6 * MaxCharWidth;
      // forever draw black and draw white lines on the top of status bar
      SelectObject( hDC, GetStockObject( WHITE_PEN ) );
      MoveTo( hDC, 0, 0 );
      LineTo( hDC, rcClient.right, 0 );
      SelectObject( hDC, GetStockObject( BLACK_PEN ) );
      MoveTo( hDC, 0, 0 );
      LineTo( hDC, rcClient.right, 0 );
      // set the vertical coordinates for the panel rectangle
      rcPanel.top = 3;
      rcPanel.bottom = rcClient.bottom - 1;
      yTextPos = rcPanel.top + ( rcPanel.bottom - rcPanel.top - Height) / 2;
      //------------------------------------------------------ Progress
      if ( isInProgress )
      {
         // get the value of progress indicator (percent). Set to zero if falure
         if ( UpperLimit != 0 ) {
            UpperLimit   = (UpperLimit<0)   ? -UpperLimit   : UpperLimit;
            CurrentState = (CurrentState<0) ? -CurrentState : CurrentState;
            CurrentState = (CurrentState>UpperLimit) ? UpperLimit : CurrentState;
            Percent = 100 * CurrentState / UpperLimit;
         }
         else {
            Percent = 0;
         }
         // convert it to string
         wsprintf( lpszPercent, " (%4ld) %%",  Percent);

         rcPanel.left = MaxCharWidth;
         rcPanel.right = rcClient.right - MaxCharWidth;
         hClipRgn = DrawPanelAndSetClipRgn( hDC, &rcPanel );
         // fill the part of panel bar with gray color
         DrawPercentBar( hDC, &rcPanel, Percent );
         // print 'Progress hint' string
         MoveTo( hDC, rcPanel.left + 3, yTextPos );
         if ( hClipRgn != 0 ) DeleteObject( hClipRgn );
         {
            TextOut( hDC, 0, 0, lpszProgressHint, lstrlen( lpszProgressHint )  );
         }
         // add (see TA_UPDATECP) to the end of string the percent value
         if ( UpperLimit != 0 )
            TextOut( hDC, 0, 0, lpszPercent, lstrlen( lpszPercent )  );
         if ( hClipRgn != 0 ) DeleteObject( hClipRgn );
      }
      //------------------------------------------------------ Status hint
      else  // draw hint, position group, key group
      {
        rcPanel.right = rcClient.right - MaxCharWidth;
        rcPanel.left  = rcClient.right;
        // if the width of aux fields more then the hint once don't paint
        // aux ( PosX, PosY, CAPS, NUM, OVR )
        if ( rcClient.right > 2 * ( 3 * KeyFieldWidth + xPosWidth + yPosWidth + 4 * MaxCharWidth ) )
        {
            rcPanel.left  = rcPanel.right  - KeyFieldWidth;
            hClipRgn = DrawPanelAndSetClipRgn( hDC, &rcPanel );
          // Draw 'OVR'
          if ( hClipRgn != 0 ) DeleteObject( hClipRgn );

          rcPanel.right = rcPanel.right - MaxCharWidth/2 - KeyFieldWidth;
          rcPanel.left  = rcPanel.right  - KeyFieldWidth;
          hClipRgn = DrawPanelAndSetClipRgn( hDC, &rcPanel );
          // Draw 'NUM'
          if ( hClipRgn != 0 ) DeleteObject( hClipRgn );

          rcPanel.right = rcPanel.right - MaxCharWidth/2 - KeyFieldWidth;
          rcPanel.left  = rcPanel.right  - KeyFieldWidth;
          hClipRgn = DrawPanelAndSetClipRgn( hDC, &rcPanel );
          // Draw 'CAPS'
          if ( hClipRgn != 0 ) DeleteObject( hClipRgn );

          rcPanel.right = rcPanel.right - MaxCharWidth - KeyFieldWidth;
          rcPanel.left  = rcPanel.right - yPosWidth;
          hClipRgn = DrawPanelAndSetClipRgn( hDC, &rcPanel );
          // Draw 'PosY'
          if ( hClipRgn != 0 ) DeleteObject( hClipRgn );

          rcPanel.right = rcPanel.right - MaxCharWidth/2 - yPosWidth;
          rcPanel.left  = rcPanel.right - xPosWidth;
          hClipRgn = DrawPanelAndSetClipRgn( hDC, &rcPanel );
          // Draw 'PosX'
          if ( hClipRgn != 0 ) DeleteObject( hClipRgn );
        }
        rcPanel.right = rcPanel.left - MaxCharWidth;
        rcPanel.left  = MaxCharWidth;
        hClipRgn = DrawPanelAndSetClipRgn( hDC, &rcPanel );
        // Draw 'Hint'
        MoveTo( hDC, rcPanel.left + 3, yTextPos );
        TextOut( hDC, 0, 0, lpszHint, lstrlen( lpszHint )  );
        if ( hClipRgn != 0 ) DeleteObject( hClipRgn );
    }
    // Restore display context to its original state. Delete GDI objects.
    DeleteObject( hFacePen );
    DeleteObject( hShadowPen );
    RestoreDC( hDC, SavedDC );
   }
   EndPaint(hWnd,&ps);
}
void DrawPercentBar( HDC hDC, LPRECT rc, INTEGER Percent )
{
   HRGN   hBarRgn;
   RECT   rcBar,rcClip;
   HBRUSH hSaveBrush;

   rcBar = *rc;
   rcBar.right = rcBar.left + (rcBar.right - rcBar.left) * Percent / 100;
   hBarRgn = CreateRectRgn(rcBar.left, rcBar.top, rcBar.right, rcBar.bottom );
   FillRgn( hDC, hBarRgn, GetStockObject( GRAY_BRUSH ) );
   DeleteObject( hBarRgn );
}
HRGN DrawPanelAndSetClipRgn( HDC hDC, LPRECT rc )
{
   HRGN hRgn;
   SelectClipRgn ( hDC, NULL );

   SelectObject( hDC, hShadowPen );
   MoveTo( hDC, rc->left, rc->bottom );
   LineTo( hDC, rc->left, rc->top );
   LineTo( hDC, rc->right, rc->top );

   SelectObject( hDC, hFacePen );
   LineTo( hDC, rc->right, rc->bottom );
   LineTo( hDC, rc->left, rc->bottom );

   hRgn = CreateRectRgn(rc->left, rc->top, rc->right, rc->bottom );
   SelectClipRgn ( hDC, hRgn );
   return hRgn;
}
void StatusLine_StartProgress(INTEGER handle,POINTER lpszProgressHint, INTEGER UpperLimit)
{
   HANDLE               hStatusLine;
   LPSTATUSLINESTRUCT   sl;
   HWND                 hWnd = LOWORD( handle );

   hStatusLine = GetProp( hWnd, STATUSLINE);
   sl = (LPSTATUSLINESTRUCT)GlobalLock( hStatusLine );
   if ( sl != NULL ) {
      if (lpszProgressHint != NULL) {
         lstrcpyn( sl->ProgressHint, lpszProgressHint, 256 );
         sl->ProgressHint[255] = 0;
      }
      else {
         sl->ProgressHint[0] = 0;
      }
      sl->isInProgress  = TRUE;
      sl->UpperLimit    = UpperLimit;
      sl->CurrentState  = 0;
      InvalidateRect( hWnd, NULL, TRUE );
      UpdateWindow ( hWnd );
   }
   // we don't unlock FIXED memory
}
void StatusLine_StopProgress( INTEGER handle )
{
   HANDLE               hStatusLine;
   LPSTATUSLINESTRUCT   sl;
   HWND                 hWnd = LOWORD( handle );

   hStatusLine = GetProp( hWnd, STATUSLINE);
   sl = (LPSTATUSLINESTRUCT)GlobalLock( hStatusLine );
   if (sl !=NULL) {
      sl->isInProgress    = FALSE;
      sl->ProgressHint[0] = 0;
      sl->UpperLimit      = 0;
      sl->CurrentState    = 0;
      InvalidateRect( hWnd, NULL, TRUE );
      UpdateWindow ( hWnd );
   }
   // we don't unlock FIXED memory
}
void StatusLine_UpdateProgressIndicator(INTEGER handle, INTEGER CurrentState)
{
   HANDLE               hStatusLine;
   LPSTATUSLINESTRUCT   sl;
   HWND                 hWnd = LOWORD( handle );

   hStatusLine = GetProp( hWnd, STATUSLINE);
   sl = (LPSTATUSLINESTRUCT)GlobalLock( hStatusLine );
   if (sl !=NULL) {
      if ( sl->isInProgress == TRUE )
      {
         sl->CurrentState = CurrentState;

         if ( sl->CurrentState < sl->UpperLimit ) {
            InvalidateRect( hWnd, NULL, TRUE );
            UpdateWindow ( hWnd );
         }
         else {
            StatusLine_StopProgress( hWnd );
         }
      }
   }
   // we don't unlock FIXED memory
}
BOOLEAN StatusLine_Init( INTEGER handle )
{
   BOOLEAN  rc;
   HANDLE   hStatusLine;
   HWND     hWnd = LOWORD( handle );

   hStatusLine = GetProp( hWnd, STATUSLINE);
   if ( hStatusLine != 0 ) {
      GlobalFree( hStatusLine );
   }
   hStatusLine = GlobalAlloc( GPTR, sizeof( STATUSLINESTRUCT ) );
   rc = ( hStatusLine != 0 );
   SetProp( hWnd, STATUSLINE, hStatusLine );
   return rc;
}
void StatusLine_SetHint( INTEGER handle, POINTER lpszHint )
{
   LPSTATUSLINESTRUCT   sl;
   HANDLE               hStatusLine;
   HWND                 hWnd = LOWORD( handle );

   hStatusLine = GetProp( hWnd, STATUSLINE);
   sl = (LPSTATUSLINESTRUCT)GlobalLock( hStatusLine );
   if (sl != NULL) {
      if (lpszHint != NULL) {
         lstrcpyn( sl->Hint, lpszHint, 256 );
         sl->Hint[255] = 0;
      }
      else {
         sl->Hint[0] = 0;
      }
   }
}
