-- Copyright (c) by:
--
--   Ulter Systems Ltd.                    Pulse Train Technology Ltd.
--   77 Shchelkovskoe Shosse               30 Alan Turing Road
--   107497 Moscow, Russia                 Guilford, Surrey GU5AA, England
--   tel./fax +7095 460 4710               tel. +44 483 300 100
--                                         fax  +44 483 302 194
----------------------------------------------------------------------------
-- Name        : MANAGER
-- ACN         :
-- Cluster     :
-- Author      : Kirill_Seitkhalilov
-- Test        : _Z
-- Entered     :
-- Lines       : ????
----------------------------------------------------------------------------
-- Description : The module ...
--             :
----------------------------------------------------------------------------
-- Purpose     :
----------------------------------------------------------------------------
-- Updated     :
-- Added       :
-- Deleted     :
-- Changed     :
-- Lines       :
-- Description :
--             :
----------------------------------------------------------------------------
class MANAGER
inherit
   WORKSHOP
creation
   make
----------------------------------------------------------------------------
feature
   make is
   do
      created_window := Void;
      init;
   end
   ---------------------------------------------------- init
   init() is
   once
      if register( $callback ) then
         init_gddvt(gddvt)
         !!list.make(true)
         uniquie_id := 100
      end
   end;
   ---------------------------------------------------- register
   register( p : POINTER ) : BOOLEAN is
   external "C"
   alias    "m_register"
   end;

----------------------------------------------------------------------------
feature { WINDOW }
   ---------------------------------------------------- create_window
   create_window( w: WINDOW ) : BOOLEAN is
   local
      menu : INTEGER
   do
      created_window := w;
      Result := create_window_from_manager(
         0,
         w.class_name.to_external,
         w.title.to_external,
         w.style,
         w.rect.x, w.rect.y, w.rect.w, w.rect.h,
         menu );
      if w.class_name.is_equal( "EiffelButton")      OR ELSE
         w.class_name.is_equal( "EiffelEdit")        OR ELSE
         w.class_name.is_equal( "EiffelListbox")     OR ELSE
         w.class_name.is_equal( "EiffelScrollbar")   then
         w.set_as_alias;
      end;
   end
   ---------------------------------------------------- create_child
   create_child( w: WINDOW, parent: WINDOW ) : BOOLEAN is
   do
      created_window := w
      Result := create_window_from_manager(
         parent.handle,
         w.class_name.to_external,
         w.title.to_external,
         w.style,
         w.rect.x, w.rect.y, w.rect.w, w.rect.h,
         get_uniquie_id );
      if w.class_name.is_equal( "EiffelButton")      OR ELSE
         w.class_name.is_equal( "EiffelEdit")        OR ELSE
         w.class_name.is_equal( "EiffelListbox")     OR ELSE
         w.class_name.is_equal( "EiffelScrollbar")   then
         w.set_as_alias;
      end;
   end;
-----------------------------------------------------------------------------
feature -- { NONE }
   ---------------------------------------------------- uniquie_id
   uniquie_id : INTEGER
   ---------------------------------------------------- get_uniquie_id
   get_uniquie_id() : INTEGER is
   do
      Result := uniquie_id
      uniquie_id := uniquie_id + 1
   end

   created_window : WINDOW
   ---------------------------------------------------- gddvt
   gddvt : MESSAGE_TABLE is
   once
      !!Result.make(true)
   end
   ---------------------------------------------------- list
   list       : WINDOW_TABLE
   ---------------------------------------------------- default
   default( hwnd, msg, wparam, lparam : INTEGER ) : INTEGER is
   external "CWC"
   alias    "m_default"
   end
   ---------------------------------------------------- callback
   callback( hwnd, msg, wparam, lparam : INTEGER ) : INTEGER is
      --
   local
      message : MESSAGE
      ok      : BOOLEAN
      w       : WINDOW
   do

      !!message.make( created_window, hwnd, msg, wparam, lparam );

      list.search( hwnd );
      if list.found  then
         message.set_target( list.found_item )
      end;

      ok := dispatch( gddvt, message, Current )
      if message.window /= Void then
          w := message.window;
          ok := dispatch( w.wddvt, message, w )
          ok := dispatch( w.cddvt, message, w )
      end
--      if message.rejected then
         Result := default( message.hwnd, message.id,
                            message.wparam, message.lparam )
--      else
--         Result := message.rc;
--      end
   end;
   ---------------------------------------------------- dispatch
   dispatch( mt : MESSAGE_TABLE, msg: MESSAGE, cur : ANY) : BOOLEAN is
   local
      p : POINTER;
      rc : INTEGER;
   do
      if mt /= Void then
         mt.search( msg.id );
         if mt.found  then
            Result := true;
            p := hacker.i2p( mt.found_item );
--            rc := execute( cur, msg, p );  -- (STH) 05-17-93 for Borland 3.1
            rc := execute( cur, msg, mt.found_item );
            msg.return( rc );
          end;
      end;
   end;
   ---------------------------------------------------- execute
   execute(
      window : ANY,
      msg    : MESSAGE,
--      method : POINTER) : INTEGER is    -- (STH) 05-17-93 for Borland 3.1
      method : INTEGER) : INTEGER is
   external "CWC"
   alias    "m_execute"
   end
   ---------------------------------------------------- create_window_from_manager
   create_window_from_manager(
      parent : INTEGER,
      class_name : POINTER,
      title :  POINTER,
      style : INTEGER,
      x, y, cx, cy, mn_or_id : INTEGER ) : BOOLEAN is
   external "CWC"
   end
   ---------------------------------------------------- init_gddvt
   init_gddvt ( mt : MESSAGE_TABLE ) is
   do
      mt.add( hacker.p2i( $on_nc_create ),         api.wm_ncCreate );
      mt.add( hacker.p2i( $on_nc_destroy ),        api.wm_ncDestroy );
      mt.add( hacker.p2i( $on_create ),            api.wm_Create );
      mt.add( hacker.p2i( $on_paint  ),            api.wm_Paint  );
      mt.add( hacker.p2i( $on_size   ),            api.wm_Size   );
      mt.add( hacker.p2i( $on_move   ),            api.wm_Move   );
--      mt.add( hacker.p2i( $on_left_button_up ),    api.wm_lButtonUp );
   end
   ---------------------------------------------------- on_nc_create
   on_nc_create( msg : MESSAGE ) : BOOLEAN is
   do
      if created_window /= Void then
         created_window.set_handle( msg.hwnd )
         list.add( created_window, msg.hwnd )
--         created_window.setup;
         created_window :=  Void
      end
--      msg.return(1)             -- don't use default WndProc
      Result := true                 -- don't execute class/window ddvt methods
   end
   ---------------------------------------------------- on_create
   on_create( msg : MESSAGE ) : BOOLEAN is
   do
         msg.window.setup;
--      msg.return(1)             -- don't use default WndProc
      Result := true                 -- don't execute class/window ddvt methods
   end
   ---------------------------------------------------- on_nc_destroy
   on_nc_destroy( msg : MESSAGE ) : BOOLEAN is
   do
      list.remove( msg.hwnd );
      if list.count = 0  then
         api.PostQuitMessage(0);
      end;
--      msg.return(1)             -- don't execute class/window ddvt methods
      Result := true               -- forget ret code and call DefWndProc
   end
   ---------------------------------------------------- on_size
   on_size( msg : MESSAGE ) : BOOLEAN is
   do
      if msg.window /= Void then
         msg.window.rect.set_size( msg.lo_word, msg.hi_word );
      end;
      Result := true                 -- don't execute class/window ddvt methods
   end
   ---------------------------------------------------- on_move
   on_move( msg : MESSAGE ) : BOOLEAN is
   do
      if msg.window /= Void then
         msg.window.rect.set_pos( msg.lo_word, msg.hi_word );
      end;
      Result := true                 -- don't execute class/window ddvt methods
   end
   ---------------------------------------------------- on_paint
   on_paint( msg : MESSAGE ) : BOOLEAN is
   local
      paint_info : PAINT_INFO;
      w          : WINDOW;
      context    : INTEGER;
   do
      w := msg.window;
      if w /= Void then
         if NOT w.is_alias  then
            !!paint_info.make;
            context :=api.BeginPaint( w.handle, paint_info.to_external );
            w.set_context( context );
            context := paint_info.context;
            w.paint;
            w.set_context( 0 );
            api.EndPaint( w.handle, paint_info.to_external );
            paint_info.free;
            Result := true         -- forget ret code and call DefWndProc
         else
            -- alias (button must call DefWndProc...)
         end; -- if

      end;
   end
   ---------------------------------------------------- on_nc_destroy
   on_left_button_up( msg : MESSAGE ) : BOOLEAN is
   do
      api.MessageBeep(0);
--      msg.return(1)             -- don't execute class/window ddvt methods
      Result := true               -- forget ret code and call DefWndProc
   end

end -- MANAGER
