#include "eiffel.h"
#include "windows.h"

INTEGER api_SendMessage( hWnd, msg, wParam, lParam )
INTEGER hWnd;
INTEGER msg;
INTEGER wParam;
INTEGER lParam;
{
   return SendMessage(  LOWORD(hWnd), LOWORD(msg),
                        LOWORD(wParam),(LPARAM)(lParam));
}
BOOLEAN api_PostMessage( hWnd, msg, wParam, lParam )
INTEGER hWnd;
INTEGER msg;
INTEGER wParam;
INTEGER lParam;
{
   return PostMessage(  LOWORD(hWnd), LOWORD(msg),
                        LOWORD(wParam),(LPARAM)(lParam));
}
void api_PostQuitMessage( INTEGER nExitCode )
{
   PostQuitMessage( LOWORD(nExitCode) );
}
void api_MessageBeep( INTEGER uAlert )
{
   MessageBeep( LOWORD(uAlert) );
}
void api_MessageBox( INTEGER hwnd, POINTER title, POINTER text )
{
   MessageBox( LOWORD(hwnd), text, title, MB_OK | MB_ICONINFORMATION );
}
BOOLEAN api_EnableWindow( INTEGER hwnd, BOOLEAN state )
{
   return EnableWindow( LOWORD(hwnd), (BOOL)(state) );
}
BOOLEAN api_ShowWindow( INTEGER hwnd, INTEGER nCmdShow )
{
   return ShowWindow( LOWORD(hwnd), LOWORD(nCmdShow) );
}
void api_UpdateWindow( INTEGER hwnd )
{
   UpdateWindow( LOWORD(hwnd));
}
void api_InvalidateRect( INTEGER hwnd, POINTER rc, BOOLEAN fErase )
{
   InvalidateRect( LOWORD(hwnd), (LPRECT)rc, (BOOL)fErase );
}
INTEGER api_BeginPaint( INTEGER hwnd, POINTER ps)
{
  return BeginPaint((HWND)LOWORD(hwnd),(LPPAINTSTRUCT)ps);
}
void api_EndPaint( INTEGER hwnd, POINTER ps)
{
  EndPaint((HWND)LOWORD(hwnd),(LPPAINTSTRUCT)ps);
}
LONG api_MoveWindow( hwnd, x, y, w, h, repaint)
INTEGER hwnd;
INTEGER x;
INTEGER y;
INTEGER w;
INTEGER h;
INTEGER repaint;
{
   return (INTEGER) MoveWindow(  LOWORD( hwnd ),
                      LOWORD( x ), LOWORD( y ),
                      LOWORD( w ), LOWORD( h ),
                      LOWORD( repaint ) );
}
//   alias    "api_ GetStockObject"
INTEGER api_GetStockObject ( INTEGER fnObject )
{
   return (INTEGER) GetStockObject( LOWORD( fnObject ) );
}
//   alias    "api_ IsGDIObject"
INTEGER api_IsGDIObject ( INTEGER fnObject )
{
   return (INTEGER) IsGDIObject( LOWORD( fnObject ) );
}
//   alias    "api_ DeleteObject"
INTEGER api_DeleteObject ( INTEGER hgdiobj )
{
   return (INTEGER) DeleteObject( LOWORD( hgdiobj ) );
}
//   alias    "api_ SelectObject"
INTEGER api_SelectObject ( INTEGER hDC, INTEGER hgdiobj )
{
   return (INTEGER) SelectObject( LOWORD( hDC ), LOWORD( hgdiobj ) );
}
//   alias    "api_ GetSysColor"
INTEGER api_GetSysColor ( INTEGER index )
{
   return (INTEGER) GetSysColor( LOWORD( index ) );
}

//   alias    "api_ CreatePen"
INTEGER api_CreatePen( INTEGER style, INTEGER width, INTEGER color )
{
   return (INTEGER) CreatePen( LOWORD( style ),
                    LOWORD( width ), (COLORREF)color );
}
//   alias    "api_ CreateSolidBrush"
INTEGER api_CreateSolidBrush ( INTEGER color )
{
   return (INTEGER) CreateSolidBrush( (COLORREF)color );
}
//   alias    "api_ CreateHatchBrush"
INTEGER api_CreateHatchBrush ( INTEGER style, INTEGER color )
{
   return (INTEGER) CreateHatchBrush( LOWORD( style ), (COLORREF)color );
}
//   alias    "api_ MoveTo"
INTEGER api_MoveTo ( INTEGER hDC, INTEGER x, INTEGER y )
{
   return (INTEGER) MoveTo( LOWORD( hDC ), LOWORD( x ), LOWORD( y )  );
}
//   alias    "api_ LineTo"
INTEGER api_LineTo ( INTEGER hDC, INTEGER x, INTEGER y )
{
   return (INTEGER) LineTo( LOWORD( hDC ), LOWORD( x ), LOWORD( y )  );
}
//   alias    "api_ Rectangle"
INTEGER api_Rectangle ( hDC, x1, y1, x2, y2)
INTEGER hDC;
INTEGER x1;
INTEGER y1;
INTEGER x2;
INTEGER y2;
{
   return (INTEGER) Rectangle(   LOWORD( hDC ),
                      LOWORD( x1 ), LOWORD( y1 ),
                                 LOWORD( x2 ), LOWORD( y2 ));
}
//   alias    "api_ RoundRect"
INTEGER api_RoundRect ( hDC, x1, y1, x2, y2, x3, y3)
INTEGER hDC;
INTEGER x1;
INTEGER y1;
INTEGER x2;
INTEGER y2;
INTEGER x3;
INTEGER y3;
{
   return (INTEGER) RoundRect(   LOWORD( hDC ),
                      LOWORD( x1 ), LOWORD( y1 ),
                      LOWORD( x2 ), LOWORD( y2 ),
                     LOWORD( x3 ), LOWORD( y3 ));
}
//   alias    "api_ Ellipse"
INTEGER api_Ellipse( hDC, x1, y1, x2, y2)
INTEGER hDC;
INTEGER x1;
INTEGER y1;
INTEGER x2;
INTEGER y2;
{
   return (INTEGER) Ellipse(  LOWORD( hDC ),
                    LOWORD( x1 ), LOWORD( y1 ),
                              LOWORD( x2 ), LOWORD( y2 ));
}
//   alias    "api_ Pie"
INTEGER api_Pie( hDC, x1, y1, x2, y2, x3, y3, x4, y4)
INTEGER hDC;
INTEGER x1;
INTEGER y1;
INTEGER x2;
INTEGER y2;
INTEGER x3;
INTEGER y3;
INTEGER x4;
INTEGER y4;
{
   return (INTEGER) Pie(   LOWORD( hDC ),
                  LOWORD( x1 ), LOWORD( y1 ),
                  LOWORD( x2 ), LOWORD( y2 ),
                  LOWORD( x3 ), LOWORD( y3 ),
                           LOWORD( x4 ), LOWORD( y4 ));
}
//   alias    "api_ Arc"
INTEGER api_Arc( hDC, x1, y1, x2, y2, x3, y3, x4, y4)
INTEGER hDC;
INTEGER x1;
INTEGER y1;
INTEGER x2;
INTEGER y2;
INTEGER x3;
INTEGER y3;
INTEGER x4;
INTEGER y4;
{
   return (INTEGER) Arc(   LOWORD( hDC ),
                  LOWORD( x1 ), LOWORD( y1 ),
                  LOWORD( x2 ), LOWORD( y2 ),
                  LOWORD( x3 ), LOWORD( y3 ),
                           LOWORD( x4 ), LOWORD( y4 ));
}
//   alias    "api_ TextOut"
INTEGER api_TextOut( hDC, x, y, str, count)
INTEGER hDC;
INTEGER x;
INTEGER y;
INTEGER str;
INTEGER count;
{
   return (INTEGER) TextOut(  LOWORD( hDC ),
                              LOWORD( x ), LOWORD( y ),
                              (LPSTR)str, LOWORD( count ) );

}
//   alias    "api_ SetTextColor"
INTEGER api_SetTextColor ( INTEGER hDC, INTEGER color )
{
   return (INTEGER) SetTextColor( LOWORD( hDC ), (COLORREF)color );
}
//   alias    "api_ GetTextColor"
INTEGER api_GetTextColor ( INTEGER hDC)
{
   return (INTEGER) GetTextColor( LOWORD( hDC ) );
}
//   alias    "api_ SetBkColor"
INTEGER api_SetBkColor ( INTEGER hDC, INTEGER color )
{
   return (INTEGER) SetBkColor( LOWORD( hDC ), (COLORREF)color );
}
//   alias    "api_ GetBkColor"
INTEGER api_GetBkColor ( INTEGER hDC)
{
   return (INTEGER) GetBkColor( LOWORD( hDC ) );
}
//   alias    "api_ SetBkMode"
INTEGER api_SetBkMode ( INTEGER hDC, INTEGER nMode )
{
   return (INTEGER) SetBkMode( LOWORD( hDC ), LOWORD( nMode ) );
}
//   alias    "api_ GetBkMode"
INTEGER api_GetBkMode ( INTEGER hDC )
{
   return (INTEGER) GetBkMode( LOWORD( hDC ) );
}
//   alias    "api_ SetTextAlign"
INTEGER api_SetTextAlign ( INTEGER hDC, INTEGER nAlign )
{
   return (INTEGER) SetTextAlign( LOWORD( hDC ), LOWORD( nAlign ) );
}
//   alias    "api_ GetTextAlign"
INTEGER api_GetTextAlign ( INTEGER hDC )
{
   return (INTEGER) GetTextAlign( LOWORD( hDC ) );
}
//   alias    "api_ GetCharWidth"
INTEGER api_GetCharWidth ( INTEGER hDC, INTEGER nChar )
{
   int buffer[1];
   BOOL rc;
   rc = GetCharWidth( LOWORD( hDC ),
           LOWORD( nChar ), LOWORD( nChar ), buffer);
   if (rc) return (INTEGER)buffer[1];
   return 0;
}
INTEGER api_GetTextMetrics( INTEGER hdc, POINTER tm)
{
  return GetTextMetrics((HDC)LOWORD(hdc),(LPTEXTMETRIC)tm);
}
INTEGER api_GetValue ( INTEGER window )
{
   MSG msg;
   HWND hWnd = LOWORD( window );
   while (GetMessage (&msg, /*hWnd*/ 0, /*WM_KEYFIRST, WM_KEYLAST)*/ 0, 0) )
    {
       TranslateMessage (&msg);
       DispatchMessage (&msg);
    }
   return 0;

}



