-- Copyright (c) by:
--
--   Ulter Systems Ltd.                    Pulse Train Technology Ltd.
--   77 Shchelkovskoe Shosse               30 Alan Turing Road
--   107497 Moscow, Russia                 Guilford, Surrey GU5AA, England
--   tel./fax +7095 460 4710               tel. +44 483 300 100
--                                         fax  +44 483 302 194
----------------------------------------------------------------------------
-- Name        : API_WINDOWS
-- ACN         :
-- Cluster     :
-- Author      : Kirill_Seitkhalilov
-- Test        : _Z
-- Entered     :
-- Lines       : ????
----------------------------------------------------------------------------
-- Description : The module ...
--             :
----------------------------------------------------------------------------
-- Purpose     :
----------------------------------------------------------------------------
-- Updated     :
-- Added       :
-- Deleted     :
-- Changed     :
-- Lines       :
-- Description :
--             :
----------------------------------------------------------------------------
class API_WINDOWS
creation
   make
----------------------------------------------------------------------------
feature
   make is do end;
   wm_null              : INTEGER is           0;  -- 0x0000

   wm_Create            : INTEGER is           1;  -- 0x0001
   wm_Destroy           : INTEGER is           2;  -- 0x0002
   wm_Move              : INTEGER is           3;  -- 0x0003
   wm_Size              : INTEGER is           5;  -- 0x0005
   wm_Activate          : INTEGER is           6;  -- 0x0006
   wm_SetFocus          : INTEGER is           7;  -- 0x0007
   wm_KillFocus         : INTEGER is           8;  -- 0x0008
   wm_Paint             : INTEGER is          15;  -- 0x000F
   wm_Close             : INTEGER is          16;  -- 0x0010
   wm_QueryEndSession   : INTEGER is          17;  -- 0x0011
   wm_Quit              : INTEGER is          18;  -- 0x0012
   wm_QueryOpen         : INTEGER is          19;  -- 0x0013
   wm_EraseBackground   : INTEGER is          20;  -- 0x0014
   wm_EndSession        : INTEGER is          22;  -- 0x0016
   wm_ShowWindow        : INTEGER is          24;  -- 0x0018
   wm_ctlColor          : INTEGER is          25;  -- 0x0019
   wm_ActivateApp       : INTEGER is          28;  -- 0x001C
   wm_CancelMode        : INTEGER is          31;  -- 0x001F
   wm_SetCursor         : INTEGER is          32;  -- 0x0020
   wm_MouseActivate     : INTEGER is          33;  -- 0x0021
   wm_ChildActivate     : INTEGER is          34;  -- 0x0022
   wm_QueueSync         : INTEGER is          35;  -- 0x0023
   wm_GetMinMaxInfo     : INTEGER is          36;  -- 0x0024
   wm_NextDlgCtl        : INTEGER is          40;  -- 0x0028
   wm_DrawItem          : INTEGER is          43;  -- 0x002B
   wm_MeasureItem       : INTEGER is          44;  -- 0x002C
   wm_DeleteItem        : INTEGER is          45;  -- 0x002D
   wm_vKeyToItem        : INTEGER is          46;  -- 0x002E
   wm_CharToItem        : INTEGER is          47;  -- 0x002F
   wm_SetFont           : INTEGER is          48;  -- 0x0030
   wm_GetFont           : INTEGER is          49;  -- 0x0031
   wm_CompareItem       : INTEGER is          57;  -- 0x0039
   wm_Compacting        : INTEGER is          65;  -- 0x0041
   wm_CommonNotify      : INTEGER is          68;  -- 0x0044
   wm_ncCreate          : INTEGER is         129;  -- 0x0081
   wm_ncDestroy         : INTEGER is         130;  -- 0x0082
   wm_ncCalcSize        : INTEGER is         131;  -- 0x0083
   wm_ncHitTest         : INTEGER is         132;  -- 0x0084
   wm_ncPaint           : INTEGER is         133;  -- 0x0085
   wm_ncActivate        : INTEGER is         134;  -- 0x0086
   wm_GetDlgCode        : INTEGER is         135;  -- 0x0087
   wm_InitDialog        : INTEGER is         272;  -- 0x0110
   wm_Command           : INTEGER is         273;  -- 0x0111
   wm_SysCommand        : INTEGER is         274;  -- 0x0112
   wm_Timer             : INTEGER is         275;  -- 0x0113
   wm_hScroll           : INTEGER is         276;  -- 0x0114
   wm_vScroll           : INTEGER is         277;  -- 0x0115
   wm_InitMenu          : INTEGER is         278;  -- 0x0116
   wm_InitMenuPopup     : INTEGER is         279;  -- 0x0117
   wm_MenuSelect        : INTEGER is         287;  -- 0x011F
   wm_MenuChar          : INTEGER is         288;  -- 0x0120
   wm_EnterIdle         : INTEGER is         289;  -- 0x0121
   wm_ParentNotify      : INTEGER is         528;  -- 0x0210


   ----------------------------------------------- Non-Client Mouse
   wm_ncMouseMove       : INTEGER is         160;  -- 0x00A0
   wm_ncLButtonDown     : INTEGER is         161;  -- 0x00A1
   wm_ncLButtonUp       : INTEGER is         162;  -- 0x00A2
   wm_ncLButtonDblClk   : INTEGER is         163;  -- 0x00A3
   wm_ncRButtonDown     : INTEGER is         164;  -- 0x00A4
   wm_ncRButtonUp       : INTEGER is         165;  -- 0x00A5
   wm_ncRButtonDblClk   : INTEGER is         166;  -- 0x00A6
   wm_ncMButtonDown     : INTEGER is         167;  -- 0x00A7
   wm_ncMButtonUp       : INTEGER is         168;  -- 0x00A8
   wm_ncMButtonDblClk   : INTEGER is         169;  -- 0x00A9

   ----------------------------------------------- Keyboard
   wm_KeyFirst          : INTEGER is         256;  -- 0x0100
   wm_Char              : INTEGER is         258;  -- 0x0102
   wm_DeadChar          : INTEGER is         259;  -- 0x0103
   wm_SysKeyDown        : INTEGER is         260;  -- 0x0104
   wm_SysKeyUp          : INTEGER is         261;  -- 0x0105
   wm_SysChar           : INTEGER is         262;  -- 0x0106
   wm_SysDeadChar       : INTEGER is         263;  -- 0x0107
   wm_KeyLast           : INTEGER is         264;  -- 0x0108

   ----------------------------------------------- Mouse
   wm_MouseFirst,
   wm_MouseMove         : INTEGER is         512;  -- 0x0200
   wm_LButtonDown       : INTEGER is         513;  -- 0x0201
   wm_LButtonUp         : INTEGER is         514;  -- 0x0202
   wm_LButtonDblClk     : INTEGER is         515;  -- 0x0203
   wm_RButtonDown       : INTEGER is         516;  -- 0x0204
   wm_RButtonUp         : INTEGER is         517;  -- 0x0205
   wm_RButtonDblClk     : INTEGER is         518;  -- 0x0206
   wm_MButtonDown       : INTEGER is         519;  -- 0x0207
   wm_MButtonUp         : INTEGER is         520;  -- 0x0208
   wm_MouseLast,
   wm_MButtonDblClk     : INTEGER is         521;  -- 0x0209

   ----------------------------------------------- MDI
   wm_mdiCreate         : INTEGER is         544;  -- 0x0220
   wm_mdiDestroy        : INTEGER is         545;  -- 0x0221
   wm_mdiActivate       : INTEGER is         546;  -- 0x0222
   wm_mdiRestore        : INTEGER is         547;  -- 0x0223
   wm_mdiNext           : INTEGER is         548;  -- 0x0224
   wm_mdiMaximize       : INTEGER is         549;  -- 0x0225
   wm_mdiTile           : INTEGER is         550;  -- 0x0226
   wm_mdiCascade        : INTEGER is         551;  -- 0x0227
   wm_mdiIconArrange    : INTEGER is         552;  -- 0x0228
   wm_mdiGetActive      : INTEGER is         553;  -- 0x0229
   wm_mdiSetMenu        : INTEGER is         554;  -- 0x0230

  ----------------------------------------------- Clipboard command
   wm_Cut               : INTEGER is         768;  -- 0x0300
   wm_Copy              : INTEGER is         769;  -- 0x0301
   wm_Paste             : INTEGER is         770;  -- 0x0302
   wm_Clear             : INTEGER is         771;  -- 0x0303
   wm_Undo              : INTEGER is         772;  -- 0x0304
   wm_RenderFormat      : INTEGER is         773;  -- 0x0305
   wm_RenderAllFormats  : INTEGER is         774;  -- 0x0306
   wm_DestroyClipboard  : INTEGER is         775;  -- 0x0307
   wm_DrawClipboard     : INTEGER is         776;  -- 0x0308
   wm_PaintCliboard     : INTEGER is         777;  -- 0x0309
   wm_vScrollClipboard  : INTEGER is         778;  -- 0x030A
   wm_SizeClipboard     : INTEGER is         779;  -- 0x030B
   wm_AskCBFormatName   : INTEGER is         780;  -- 0x030C
   wm_ChangeCBChain     : INTEGER is         781;  -- 0x030D
   wm_hScrollClipboard  : INTEGER is         782;  -- 0x030E

-- wm_                  : INTEGER is               -- 0x0000
   wm_user              : INTEGER is        1024;  -- 0x0400

   --
   SendMessage(
      h : INTEGER,
      msg : INTEGER,
      wp : INTEGER,
      lp : INTEGER
   ) : INTEGER is
   external "CWC"
   alias    "api_SendMessage"
   end;
   --
   PostMessage(
      h : INTEGER,
      msg : INTEGER,
      wp : INTEGER,
      lp : INTEGER
   ) : BOOLEAN is
   external "CWC"
   alias    "api_PostMessage"
   end;
-----------------------------------------------------------------------------

--   RegisterClass( lpwc : POINTER ) : BOOLEAN is
--      external "CWC"
--      alias    "api_RegisterClass"
--   end
--   UnregisterClass( lpszClassName : POINTER, hInst : INTEGER ) : BOOLEAN is
--      external "CWC"
--      alias    "api_UnregisterClass"
--   end

   cs_vRedraw           : INTEGER is           1;  -- 0x0001
   cs_hRedraw           : INTEGER is           2;  -- 0x0002
   cs_OwnDC             : INTEGER is          32;  -- 0x0020
   cs_ClassDC           : INTEGER is          64;  -- 0x0040
   cs_ParentDC          : INTEGER is         128;  -- 0x0080
   cs_SaveBits          : INTEGER is        2048;  -- 0x0800
   cs_DblClks           : INTEGER is           8;  -- 0x0008
   cs_BiteAlignClient   : INTEGER is        4096;  -- 0x1000
   cs_BiteAlignWindow   : INTEGER is        8192;  -- 0x2000
   cs_NoClose           : INTEGER is         512;  -- 0x0200
   cs_KeyCVTWindow      : INTEGER is           4;  -- 0x0004
   cs_NoKeyCVT          : INTEGER is         256;  -- 0x0100
   cs_GlobalClass       : INTEGER is       16384;  -- 0x4000

   --------------------------------------------------------------------------
--   CreateWindow(
--      lpszClassName    : POINTER,
--      lpszWindowName   : POINTER,
--      dwStyle,
--      x,
--      y,
--      nWidth,
--      nHeight,
--      hWndParent        : INTEGER,
--      hMenu             : POINTER
--      hInst             : POINTER
--      lpParam           : POINTER
--      )
--      is
--      external "CWC"
--      alias    "api_CreateWindow"
--      end

   cw_UseDefault        : INTEGER is       32768;  -- 0x8000

   ws_Overlapped        : INTEGER is           0;  -- 0x00000000
   ws_Popup             : INTEGER is  2147483648;  -- 0x80000000
   ws_Child             : INTEGER is  1073741824;  -- 0x40000000
   ws_ClipSiblings      : INTEGER is    67108864;  -- 0x04000000
   ws_ClipChildren      : INTEGER is    33554432;  -- 0x02000000
   ws_Visiable          : INTEGER is   268435456;  -- 0x10000000
   ws_Disable           : INTEGER is   134217728;  -- 0x08000000
   ws_Minimize          : INTEGER is   536870912;  -- 0x20000000
   ws_Maximize          : INTEGER is    16777216;  -- 0x01000000
   ws_Caption           : INTEGER is    12582912;  -- 0x00C00000
   ws_Border            : INTEGER is     8388608;  -- 0x00800000
   ws_DlgFrame          : INTEGER is     4194304;  -- 0x00400000
   ws_vScroll           : INTEGER is     2097152;  -- 0x00200000
   ws_hScroll           : INTEGER is     1048576;  -- 0x00100000
   ws_SysMenu           : INTEGER is      524288;  -- 0x00080000
   ws_ThicFrame         : INTEGER is      262144;  -- 0x00040000
   ws_MinimizeBox       : INTEGER is      131072;  -- 0x00020000
   ws_MaximizeBox       : INTEGER is       65536;  -- 0x00010000
   ws_Group             : INTEGER is      131072;  -- 0x00020000
   ws_TabStop           : INTEGER is       65536;  -- 0x00010000

   ws_OverlappedWindow  : INTEGER is    13565952;  -- 0x00CF0000
   ws_ChildWindow       : INTEGER is  1073741824;  -- 0x40000000
   ws_PopupWindow       : INTEGER is  2156396544;  -- 0x80880000

   ss_Left              : INTEGER is           0;  -- 0x00000000  -- default
   ss_Center            : INTEGER is           1;  -- 0x00000001
   ss_Right             : INTEGER is           2;  -- 0x00000002
   ss_Icon              : INTEGER is           3;  -- 0x00000003
   ss_BlackRect         : INTEGER is           4;  -- 0x00000004
   ss_GrayRect          : INTEGER is           5;  -- 0x00000005
   ss_WhiteRect         : INTEGER is           6;  -- 0x00000006
   ss_BlackFrame        : INTEGER is           7;  -- 0x00000007
   ss_GrayFrame         : INTEGER is           8;  -- 0x00000008
   ss_WhiteFrame        : INTEGER is           9;  -- 0x00000009
   ss_Simple            : INTEGER is          11;  -- 0x0000000B
   ss_LeftNoWordWrap    : INTEGER is          12;  -- 0x0000000C
   ss_NoPrefix          : INTEGER is         128;  -- 0x00000080

   bs_PushButton        : INTEGER is           0;  -- 0x00000000
   bs_DefPushButton     : INTEGER is           1;  -- 0x00000001
   bs_CheckBox          : INTEGER is           2;  -- 0x00000002
   bs_AutoCheckBox      : INTEGER is           3;  -- 0x00000003
   bs_RadioButton       : INTEGER is           4;  -- 0x00000004
   bs_3State            : INTEGER is           5;  -- 0x00000005
   bs_Auto3State        : INTEGER is           6;  -- 0x00000006
   bs_GroupBox          : INTEGER is           7;  -- 0x00000007
   bs_UserButton        : INTEGER is           8;  -- 0x00000008
   bs_AutoRadioButton   : INTEGER is           9;  -- 0x00000009
   bs_OwnerDraw         : INTEGER is          11;  -- 0x0000000B
   bs_LeftText          : INTEGER is          32;  -- 0x00000020

   es_Left              : INTEGER is           0;  -- 0x00000000 -- default
   es_Center            : INTEGER is           1;  -- 0x00000001
   es_Right             : INTEGER is           2;  -- 0x00000002
   es_Multiline         : INTEGER is           4;  -- 0x00000004
   es_UpperCase         : INTEGER is           8;  -- 0x00000008
   es_LowerCase         : INTEGER is          16;  -- 0x00000010
   es_Password          : INTEGER is          32;  -- 0x00000020
   es_AutoVScroll       : INTEGER is          64;  -- 0x00000040
   es_AutoHScroll       : INTEGER is         128;  -- 0x00000080
   es_NoHideSel         : INTEGER is         256;  -- 0x00000100
   es_OEMConvert        : INTEGER is        1024;  -- 0x00000400
   es_ReadOnly          : INTEGER is        2048;  -- 0x00000800 -- 3.10
   es_WantReturn        : INTEGER is        4096;  -- 0x00001000 -- 3.10

   sbs_Horz             : INTEGER is           0;  -- 0x00000000 -- default
   sbs_Vert             : INTEGER is           1;  -- 0x00000001
   sbs_TopAlign         : INTEGER is           2;  -- 0x00000002
   sbs_LeftAlign        : INTEGER is           2;  -- 0x00000002
   sbs_BottomAlign      : INTEGER is           4;  -- 0x00000004
   sbs_RightAlign       : INTEGER is           4;  -- 0x00000004
   sbs_SizeBox          : INTEGER is           8;  -- 0x00000008

   lbs_Notify           : INTEGER is           1;  -- 0x00000001
   lbs_Sort             : INTEGER is           2;  -- 0x00000002
   lbs_NoRedraw         : INTEGER is           4;  -- 0x00000004
   lbs_MultipleSel      : INTEGER is           8;  -- 0x00000008
   lbs_OwnerDrawFixed   : INTEGER is          16;  -- 0x00000010
   lbs_OwnerDrawVariable: INTEGER is          32;  -- 0x00000020
   lbs_HasString        : INTEGER is          64;  -- 0x00000040
   lbs_UseTabStops      : INTEGER is         128;  -- 0x00000080
   lbs_NoINtegralHeight : INTEGER is         256;  -- 0x00000100
   lbs_MultiColumn      : INTEGER is         512;  -- 0x00000200
   lbs_WantKeyboardInput: INTEGER is        1024;  -- 0x00000400
   lbs_ExtendedSel      : INTEGER is        2048;  -- 0x00000800
   lbs_DisableNoScroll  : INTEGER is        4096;  -- 0x00001000 -- 3.10
   lbs_Standard         : INTEGER is    10485763;  -- 0x00A00003

-----------------------------------------------------------------------------
feature { WINDOW, APPLICATION, MANAGER }
   MessageBox( hwnd : INTEGER, title : POINTER, text : POINTER ) is
      external "CWC"
      alias "api_MessageBox"
      end;

   ---------------------------------------------------- MessageBeep
   MessageBeep( int : INTEGER ) is
      external "CWC"
      alias "api_MessageBeep"
      end;
   ---------------------------------------------------- PostQuitMessage
   PostQuitMessage( nExitCode : INTEGER ) is
      external "CWC"
      alias    "api_PostQuitMessage"
      end;

   EnableWindow( hWnd : INTEGER, state : BOOLEAN ) : BOOLEAN is
      external "CWC"
      alias    "api_EnableWindow"
      end;
   ----------------------------------------------- ShowWindow function
   ShowWindow( hWnd : INTEGER, nCmdShow : INTEGER ) : BOOLEAN is
      external "CWC"
      alias    "api_ShowWindow"
      end;
   ----------------------------------------------- ShowWindow function
   UpdateWindow( hWnd : INTEGER ) is
      external "CWC"
      alias    "api_UpdateWindow"
      end;
   ---------------------------------------------------- InvalidateRect
   InvalidateRect( hWnd : INTEGER, rc : POINTER, fErase : BOOLEAN ) is
      external "CWC"
      alias    "api_InvalidateRect"
      end;
   ---------------------------------------------------- MoveWindow
   MoveWindow(
      hWnd : INTEGER,
      x : INTEGER, y : INTEGER,
      w : INTEGER, h : INTEGER,
      repaint : BOOLEAN
   ) : BOOLEAN is
   external "CWC"
   alias    "api_MoveWindow"
   end;
   ----------------------------------------------- Show Window constants
   Hide_Window,
   sw_Hide              : INTEGER is           0;
   Show_OpenWindow,
   sw_ShowNormal,
   sw_Normal            : INTEGER is           1;
   Show_IconWindow,
   sw_ShowMinimized     : INTEGER is           2;
   Show_FullScreen,
   sw_Maximize,
   sw_ShowMaximized     : INTEGER is           3;
   Show_OpenNoActivate,
   sw_ShowNoActivate    : INTEGER is           4;
   sw_Show              : INTEGER is           5;
   sw_Minimize          : INTEGER is           6;
   sw_ShowMinNoActivate : INTEGER is           7;
   sw_NA                : INTEGER is           8;
   sw_Restore           : INTEGER is           9;
   -----------------------------------------------
--   LoadCursor ( hInstance : POINTER, lpcszCursor : POINTER ) : POINTER is
--      external "CWC"
--      alias    "api_LoadCursor"
--      end
--   DestroyCursor ( hCursor : POINTER ) : BOOLEAN is
--      external "CWC"
--      alias    "api_DestroyCursor"
--      end
--   LoadIcon ( hInstance : POINTER, lpcszIcon : POINTER ) : POINTER is
--      external "CWC"
--      alias    "api_LoadIcon"
--      end
--   DestroyIcon ( hIcon : POINTER ) : BOOLEAN is
--      external "CWC"
--      alias    "api_DestroyIcon"
--      end

   idc_Arrow            : INTEGER is       32512;
   idc_iBeam            : INTEGER is       32513;
   idc_Wait             : INTEGER is       32514;
   idc_Cross            : INTEGER is       32515;
   idc_UpArrow          : INTEGER is       32516;
   idc_Size             : INTEGER is       32640;
   idc_Icon             : INTEGER is       32641;
   idc_SizeNWSE         : INTEGER is       32642;
   idc_SizeNESW         : INTEGER is       32643;
   idc_SizeWE           : INTEGER is       32644;
   idc_SizeNS           : INTEGER is       32645;

   idi_Application      : INTEGER is       32512;
   idi_Hand             : INTEGER is       32513;
   idi_Question         : INTEGER is       32514;
   idi_Exclamation      : INTEGER is       32515;
   idi_Asterisk         : INTEGER is       32516;

-----------------------------------------------------------------------------
----------------------- GDI Object Support ----------------------------------
feature -- { STOCK }
   ---------------------------------------------------- GetStockObject
   GetStockObject( index : INTEGER ) : INTEGER is
      external "CWC"
      alias    "api_GetStockObject"
      end;
   ---------------------------------------------------- IsGDIObject
   IsGDIObject( obj : INTEGER ) : BOOLEAN is
      external "CWC"
      alias    "api_IsGDIObject"
      end;
   ---------------------------------------------------- DeleteObject
   DeleteObject(obj : INTEGER ) : BOOLEAN is
      external "CWC"
      alias    "api_DeleteObject"
      end;
   ---------------------------------------------------- SelectObject
   SelectObject( hdc : INTEGER, obj : INTEGER ) : INTEGER is
      external "CWC"
      alias    "api_SelectObject"
      end;
----------------------------------------------- Stock constant (brushes)
   WhiteBrush           : INTEGER is           0;
   LtGrayBrush          : INTEGER is           1;
   GrayBrush            : INTEGER is           2;
   DkGrayBrush          : INTEGER is           3;
   BlackBrush           : INTEGER is           4;
   HollowBrush,
   NullBrush            : INTEGER is           5;
   ----------------------------------------------- Stock constant (pens)
   White_Pen            : INTEGER is           6;
   Black_Pen            : INTEGER is           7;
   Null_Pen             : INTEGER is           8;
   ----------------------------------------------- Stock constant (fonts)
   oem_fixed_font       : INTEGER is          10;
   ansi_fixed_font      : INTEGER is          11;
   ansi_var_font        : INTEGER is          12;
   system_font          : INTEGER is          13;
   device_default_font  : INTEGER is          14;
   system_fixed_font    : INTEGER is          16;
   ----------------------------------------------- Stock constant (palettes)
   default_palette      : INTEGER is          15;
-----------------------------------------------------------------------------
----------------------------- Pen Support -----------------------------------
feature
   CreatePen( style : INTEGER, width : INTEGER, color : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_CreatePen"
   end;
   --- CreatePenIndirect( p : POINTER ) : INTEGER is
                                                -- Pen Styles
   ps_Solid             : INTEGER is           0;
   ps_Dash              : INTEGER is           1;
   ps_Dot               : INTEGER is           2;
   ps_DashDot           : INTEGER is           3;
   ps_DashDotDot        : INTEGER is           4;
   ps_Null              : INTEGER is           5;
   ps_InsideFrame       : INTEGER is           6;

   ---------------------------------------------------- GetSysColor
   GetSysColor( ind : INTEGER ) : INTEGER is
      external "CWC"
      alias    "api_GetSysColor"
      end;

   Color_ScrollBar               : INTEGER is           0;
   Color_Background              : INTEGER is           1;
   Color_ActiveCaption           : INTEGER is           2;
   Color_InactiveCaption         : INTEGER is           3;
   Color_Menu                    : INTEGER is           4;
   Color_Window                  : INTEGER is           5;
   Color_WindowFrame             : INTEGER is           6;
   Color_MenuText                : INTEGER is           7;
   Color_WindowText              : INTEGER is           8;
   Color_CaptionText             : INTEGER is           9;
   Color_ActiveBorder            : INTEGER is          10;
   Color_InactiveBorder          : INTEGER is          11;
   Color_AppWorkspace            : INTEGER is          12;
   Color_Highlight               : INTEGER is          13;
   Color_HighlightText           : INTEGER is          14;
   Color_BtnFace                 : INTEGER is          15;
   Color_BtnShadow               : INTEGER is          16;
   Color_GrayText                : INTEGER is          17;
   Color_BtnText                 : INTEGER is          18;
   Color_InactiveCaptionText     : INTEGER is          19;  -- 3.10
   Color_BtnHighlight            : INTEGER is          20;  -- 3.10

-----------------------------------------------------------------------------
---------------------------- Brush Support ----------------------------------
feature
   ---------------------------------------------------- CreateSolidBrush
   CreateSolidBrush( color : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_CreateSolidBrush"
   end;
   ---------------------------------------------------- CreateHatchBrush
   CreateHatchBrush( ind : INTEGER, color : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_CreateHatchBrush"
   end;
   --- CreatePatternBrush( color : INTEGER ) : INTEGER is
   --- CreateDIBPatternBrush( color : INTEGER ) : INTEGER is
   --- CreateBrushIndirect( color : INTEGER ) : INTEGER is
   hs_Horizontal        : INTEGER is           0;
   hs_Vertical          : INTEGER is           1;
   hs_fDiagonal         : INTEGER is           2;
   hs_bDiagonal         : INTEGER is           3;
   hs_Cross             : INTEGER is           4;
   hs_DiagCross         : INTEGER is           5;
   --- SetBrushOrg( hdc : INTEGER, x : INTEGER, y : INTEGER ) : INTEGER is
   --- GetBrushOrg( hdc : INTEGER ) : INTEGER is
-----------------------------------------------------------------------------
----------------------- General Drawing Support -----------------------------
feature
   ---------------------------------------------------- MoveTo

   MoveTo( hdc : INTEGER, x : INTEGER, y : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_MoveTo"
   end;
   ---------------------------------------------------- LineTo

   LineTo( hdc : INTEGER, x : INTEGER, y : INTEGER ) : BOOLEAN is
   external "CWC"
   alias    "api_LineTo"
   end;

--    MoveToEx(
--       hdc   : INTEGER,
--       x     : INTEGER,
--       y     : INTEGER,
--       point : POINTER
--    ) : BOOLEAN is
--    GetCurrentPositionEx(
--       hdc   : INTEGER,
--       point : POINTER
--    ) : BOOLEAN is
   ---------------------------------------------------- Rectangle
   Rectangle(
      hdc   : INTEGER,
      x1    : INTEGER,
      y1    : INTEGER,
      x2    : INTEGER,
      y2    : INTEGER
   ) : BOOLEAN is
   external "CWC"
   alias    "api_Rectangle"
   end;
   ---------------------------------------------------- RoundRect
   RoundRect(
      hdc   : INTEGER,
      x1    : INTEGER,
      y1    : INTEGER,
      x2    : INTEGER,
      y2    : INTEGER,
      x3    : INTEGER,
      y3    : INTEGER
   ) : BOOLEAN is
   external "CWC"
   alias    "api_RoundRect"
   end;
   ---------------------------------------------------- Ellipse
   Ellipse(
      hdc   : INTEGER,
      x1    : INTEGER,
      y1    : INTEGER,
      x2    : INTEGER,
      y2    : INTEGER,
   ) : BOOLEAN is
   external "CWC"
   alias    "api_Ellipse"
   end;
   ---------------------------------------------------- Pie
   Pie(
      hdc   : INTEGER,
      x1    : INTEGER,
      y1    : INTEGER,
      x2    : INTEGER,
      y2    : INTEGER,
      x3    : INTEGER,
      y3    : INTEGER,
      x4    : INTEGER,
      y4    : INTEGER
   ) : BOOLEAN is
   external "CWC"
   alias    "api_Pie"
   end;
   ---------------------------------------------------- Arc
   Arc(
      hdc   : INTEGER,
      x1    : INTEGER,
      y1    : INTEGER,
      x2    : INTEGER,
      y2    : INTEGER,
      x3    : INTEGER,
      y3    : INTEGER,
      x4    : INTEGER,
      y4    : INTEGER
   ) : BOOLEAN is
   external "CWC"
   alias    "api_Arc"
   end;
-----------------------------------------------------------------------------
----------------------------- Text Support ----------------------------------
feature
   ---------------------------------------------------- TextOut
   TextOut(
      hdc : INTEGER,
      x     : INTEGER,
      y     : INTEGER,
      str   : POINTER,
      count : INTEGER
   ) : BOOLEAN is
   external "CWC"
   alias    "api_TextOut"
   end;
   ---------------------------------------------------- SetTextColor
   SetTextColor( hdc : INTEGER, color : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_SetTextColor"
   end;
   ---------------------------------------------------- GetTextColor
   GetTextColor( hdc : INTEGER) : INTEGER is
   external "CWC"
   alias    "api_GetTextColor"
   end;
   ---------------------------------------------------- SetBkColor
   SetBkColor( hdc : INTEGER, color : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_SetBkColor"
   end;
   ---------------------------------------------------- GetBkColor
   GetBkColor( hdc : INTEGER) : INTEGER is
   external "CWC"
   alias    "api_GetBkColor"
   end;
   ---------------------------------------------------- SetBkMode
   SetBkMode( hdc : INTEGER, ind : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_SetBkMode"
   end;
   ---------------------------------------------------- GetBkMode
   GetBkMode( hdc : INTEGER) : INTEGER is
   external "CWC"
   alias    "api_GetBkMode"
   end;

   Transparent          : INTEGER is           1
   Opaque               : INTEGER is           2

   ta_NoUpdateClip      : INTEGER is           0   -- 0x0000   -- Default
   ta_UpdateClip        : INTEGER is           1   -- 0x0001
   ta_Left              : INTEGER is           0   -- 0x0000   -- Default
   ta_Right             : INTEGER is           2   -- 0x0002
   ta_Center            : INTEGER is           6   -- 0x0006
   ta_Top               : INTEGER is           0   -- 0x0000   -- Default
   ta_Bottom            : INTEGER is           8   -- 0x0008
   ta_BaseLine          : INTEGER is          24   -- 0x0018

   ---------------------------------------------------- SetTextAlign
   SetTextAlign( hdc : INTEGER, ind : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_SetTextAlign"
   end;
   ---------------------------------------------------- GetTextAlign
   GetTextAlign( hdc : INTEGER ) : INTEGER is
   external "CWC"
   alias    "api_GetTextAlign"
   end;
   ---------------------------------------------------- GetCharWidth
   GetCharWidth(
      hdc    : INTEGER,
      first  : INTEGER,
--      last   : INTEGER,  -- last = first
--      buffer : POINTER
   ) : INTEGER is
   external "CWC"
   alias    "api_GetCharWidth"
   end;
   ----
   GetTextMetrics( hdc : INTEGER, text_metrics : POINTER ) : BOOLEAN is
   external "CWC"
   alias    "api_GetTextMetrics"
   end;
   ----
   BeginPaint( hwnd : INTEGER, paint_info : POINTER ) : INTEGER is
   external "CWC"
   alias    "api_BeginPaint"
   end;
   ----
   EndPaint( hwnd : INTEGER, paint_info : POINTER  ) is
   external "CWC"
   alias    "api_EndPaint"
   end;

   PaintInfo_sizeof              : INTEGER is          64;
   PaintInfo_hdc                 : INTEGER is           1;
   PaintInfo_fErase              : INTEGER is           2;
   PaintInfo_rcPaint             : INTEGER is           3;

   Rect_x                        : INTEGER is           4;
   Rect_y                        : INTEGER is           5;
   Rect_w                        : INTEGER is           6;
   Rect_h                        : INTEGER is           7;

   TextMetrics_sizeof            : INTEGER is          64;
   TextMetrics_tmHeight          : INTEGER is           8;
   TextMetrics_tmAscent          : INTEGER is           9;
   TextMetrics_tmDescent         : INTEGER is           0;
   TextMetrics_tmInternalLeading : INTEGER is          11;
   TextMetrics_tmExternalLeading : INTEGER is          12;
   TextMetrics_tmAveCharWidth    : INTEGER is          13;
   TextMetrics_tmMaxCharWidth    : INTEGER is          14;
   TextMetrics_tmWeight          : INTEGER is          15;
   TextMetrics_tmItalic          : INTEGER is          16;
   TextMetrics_tmUnderlined      : INTEGER is          17;
   TextMetrics_tmStructOut       : INTEGER is          18;
   TextMetrics_tmFirstChar       : INTEGER is          19;
   TextMetrics_tmLastChar        : INTEGER is          20;
   TextMetrics_tmBreakChar       : INTEGER is          21;
   TextMetrics_tmPitchAndFamily  : INTEGER is          22;
   TextMetrics_tmCharSet         : INTEGER is          23;
   TextMetrics_tmOverhang        : INTEGER is          24;
   TextMetrics_tmDigitizedAspectX: INTEGER is          25;
   TextMetrics_tmDigitizedAspectY: INTEGER is          26;

end -- API_WINDOWS



