
#include "c:\e\run3\eiffel.h"
#include <dos.h>
#include <time.h>
#include <stdlib.h>
#include <conio.h>

/*
---------------------------------------------------------
-- Schnittstellenmodul DOS-C-Funktionen fr     EIFFEL --
--                                                     --
--                                                     --
-- c_version              MS-DOS-Version               --
-- c_coprocessor_type     Coprozessor-Typ              --
-- c_sound                Ton erzeugen                 --
-- c_nosound              Ton abstellen                --
-- c_randomize            Zufallszahlen zeitabhngig   --
-- c_random               Zufallszahl                  --
-- c_kbhit                Tastaturabfrage              --
-- c_getch                Zeichen von Tastatur lesen   --
-- c_delay                Warten                       --
-- c_cprintf              Farbtext schreiben           --
-- c_putch                Farbzeichen schrieben        --
-- c_window               Textfenster definieren       --
-- c_clrscr               Bildschirm lschen           --
-- c_wherex               Cursorspalte                 --
-- c_wherey               Cursorzeile                  --
-- c_gotoxy               positionieren nach x,y       --
-- c_textbackground       Schrifthintergrund einstellen--
-- c_textcolor            Schriftfarbe einstellen      --
-- c_scrolling            Scrolling einschalten        --
-- c_no_scrolling         Scrolling abschalten         --
--                                                     --
---------------------------------------------------------
-- Autor   : Dr. P.G. Zint                             --
-- Datum   : 16. Juli 1992                             --
-- Version : 1.0                                       --
--                                                     --
---------------------------------------------------------
*/

/*-----------------------------------------------------*/

OBJREF  c_version ( Current )   /* DOS-Version */

OBJREF  Current ;

{
  char str [4] ;

  str [0] = _osmajor + 48 ;
  str [1] = '.' ;
  str [2] = _osminor + 48 ;
  str [3] = '\0' ;
  return RSTR_create ( ( CHARACTER *) str ) ;

}

/*-----------------------------------------------------*/

OBJREF  c_coprocessor_type ( Current )

OBJREF  Current ;

{
  char *str ;

  switch (_8087) {
  case  0: str = "nicht vorhanden" ; break ;
  case  1: str = "8087"            ; break ;
  case  2: str = "80287"           ; break ;
  case  3: str = "80387"           ; break ;
  case  4: str = "(integriert)"    ; break ;
  default: str = "unbekannt"       ; break ;
  }
  return RSTR_create ( ( CHARACTER *) str ) ;

}
/*-----------------------------------------------------*/

/*-----------------------------------------------------*/

void c_sound ( Current , ton )

OBJREF  Current ;
INTEGER ton ;

{

sound ( ton ) ;

}

/*-----------------------------------------------------*/

void c_nosound ( Current )

OBJREF  Current ;

{

nosound () ;

}

/*-----------------------------------------------------*/

void c_randomize ( Current )

OBJREF  Current ;

{

randomize ( ) ;

}

/*-----------------------------------------------------*/

INTEGER c_random ( Current , grenze )

OBJREF  Current ;
INTEGER grenze ;

{

  return (INTEGER) random ( grenze ) ;

}

/*-----------------------------------------------------*/

/*-----------------------------------------------------*/

BOOLEAN c_kbhit ( Current )

OBJREF  Current ;

{

return ( kbhit() ? true : false ) ;

}

/*-----------------------------------------------------*/

CHARACTER c_getch ( Current )

OBJREF  Current ;

{

return ( getch () ) ;

}

/*-----------------------------------------------------*/

void c_delay ( Current , dauer )

OBJREF  Current ;
INTEGER dauer ;

{

delay ( dauer ) ;

}

/*-----------------------------------------------------*/

/*-----------------------------------------------------*/

void c_cprintf ( Current , text )

OBJREF  Current ;
OBJREF  text ;

{

CHARACTER *str ;

str = RSTR_seq ( text ) ;
cprintf ( str ) ;

}

/*-----------------------------------------------------*/

void c_putch ( Current , zeichen )

OBJREF  Current ;
CHARACTER zeichen ;
{

putch ( zeichen ) ;

}

/*-----------------------------------------------------*/

/*-----------------------------------------------------*/

void c_window ( Current , links , oben , rechts , unten )

OBJREF  Current ;
INTEGER oben , links , unten , rechts ;

{

window ( links , oben , rechts , unten ) ;

}

/*-----------------------------------------------------*/

void c_clrscr ( Current )

OBJREF  Current ;

{

clrscr ( ) ;

}

/*-----------------------------------------------------*/

/*-----------------------------------------------------*/

INTEGER c_wherex ( Current )

OBJREF  Current ;

{

  return (INTEGER) wherex ( ) ;

}

/*-----------------------------------------------------*/

INTEGER c_wherey ( Current )

OBJREF  Current ;

{

  return (INTEGER) wherey ( ) ;

}

/*-----------------------------------------------------*/

void c_gotoxy ( Current , x , y )

OBJREF  Current ;
INTEGER x , y ;

{

gotoxy ( x , y ) ;

}

/*-----------------------------------------------------*/

/*-----------------------------------------------------*/

void c_textbackground ( Current , farbe )

OBJREF  Current ;
INTEGER farbe ;

{

textbackground ( farbe ) ;

}

/*-----------------------------------------------------*/

void c_textcolor ( Current , farbe )

OBJREF  Current ;
INTEGER farbe ;

{

textcolor ( farbe ) ;

}


/*-----------------------------------------------------*/

void c_scrolling ( Current )

OBJREF  Current ;

{

_wscroll = 1 ;

}

/*-----------------------------------------------------*/

void c_no_scrolling ( Current )

OBJREF  Current ;

{

_wscroll = 0 ;

}

