-----------------------------------------------------------
-- DOS                                          Eiffel 3 --
--                                                       --
--  Auswahl von DOS-Features auf BORLAND-C-Basis         --
--                                                       --
--  fr Anwender, die TURBO   PASCAL und/oder            --
--                    TURBO   C      und/oder            --
--                    Borland C                          --
--  kennen.                                              --
--                                                       --
-----------------------------------------------------------
--                                                       --
-- Autor   : Dr. P.G. Zint                               --
-- Datum   : 31. August 1992                             --
-- Version : 1.0                                         --
--                                                       --
-----------------------------------------------------------

class   DOS

feature {ANY} -- Konstanten

-- Tastaturcodes
    Esc        : CHARACTER is '%/27/'

-- Farbwerte
    Black       : INTEGER is  0
    Blue        : INTEGER is  1
    Green       : INTEGER is  2
    Cyan        : INTEGER is  3
    Red         : INTEGER is  4
    Magneta     : INTEGER is  5
    Brown       : INTEGER is  6
    Lightgray   : INTEGER is  7
    Darkgray    : INTEGER is  8
    Lightblue   : INTEGER is  9
    Lightgreen  : INTEGER is 10 
    Lightcyan   : INTEGER is 11 
    Lightred    : INTEGER is 12
    Lightmagenta: INTEGER is 13 
    Yellow      : INTEGER is 14
    White       : INTEGER is 15

    Blink       : INTEGER is 128

feature {ANY} -- Betriebssystemdaten

-----------------------------------------------------------

    version : STRING is
            -- MS-DOS-Version ermitteln

        external "C"
        alias "c_version"

        end

-----------------------------------------------------------

    coprocessor_type : STRING is
            -- Coprozessor-Typ ermitteln

        external "C"
        alias "c_coprocessor_type"

        end

-----------------------------------------------------------

feature {ANY} -- Tonerzeugung

-----------------------------------------------------------

    sound ( ton : INTEGER ) is
            -- Ton der Frequenz ton erzeugen

        external "C"
        alias "c_sound"

        end

-----------------------------------------------------------

    nosound is
            -- Ton abstellen

        external "C"
        alias "c_nosound"

        end

-----------------------------------------------------------

feature {ANY} -- Zufallszahlen und Delay

-----------------------------------------------------------

    randomize is
            -- Zufallszahlen zeitabhngig

        external "C"
        alias "c_randomize"

        end

-----------------------------------------------------------

    random ( grenze : INTEGER ) : INTEGER is
            -- Zufallszahl zwischen 0 und grenze - 1

        external "C"
        alias "c_random"

        end

-----------------------------------------------------------

    delay ( dauer : INTEGER ) is
            -- Delay erzeugen

        external "C"
        alias "c_delay"

        end

-----------------------------------------------------------

feature {ANY} -- Tastatur

-----------------------------------------------------------

    keypressed : BOOLEAN is
            -- Tastaturabfrage

        external "C"
        alias "c_kbhit"

        end

-----------------------------------------------------------

    readkey : CHARACTER is
            -- Zeichen von Tastatur lesen

        external "C"
        alias "c_getch"

        end

-----------------------------------------------------------

feature {ANY} -- Farbtextbehandlung

-----------------------------------------------------------

    farbtext ( text : STRING ; farbe : INTEGER ) is
            -- Text in Farbe schreiben

        do
            textcolor ( farbe )
            put_string ( text )
        end

-----------------------------------------------------------

    put_string ( text : STRING ) is
            -- Text schreiben

        external "C"
        alias "c_cprintf"

        end

-----------------------------------------------------------

    put_char ( zeichen : CHARACTER ) is
            -- Zeichen schreiben

        external "C"
        alias "c_putch"

        end

-----------------------------------------------------------

    put_newline is
            -- neue Zeile schreiben

        do
        put_string ( "%/10/%/13/" )
        end

-----------------------------------------------------------

-----------------------------------------------------------

    window ( links , oben , rechts , unten : INTEGER ) is
            -- Textfenster von (links,oben) bis (rechts,unten) erzeugen

        external "C"
        alias "c_window"

        end

-----------------------------------------------------------

    clrscr is
            -- Bildschirm lschen

        external "C"
        alias "c_clrscr"

        end

-----------------------------------------------------------

-----------------------------------------------------------

    wherex : INTEGER is
            -- x-Koordinate des Bildschirmcursors

        external "C"
        alias "c_wherex"

        end

-----------------------------------------------------------

    wherey : INTEGER is
            -- y-Koordinate des Bildschirmcursors

        external "C"
        alias "c_wherey"

        end

-----------------------------------------------------------

    gotoxy ( x , y : INTEGER ) is
            -- Cursor nach (x,y) positionieren

        external "C"
        alias "c_gotoxy"

        end


-----------------------------------------------------------

    textbackground ( farbe : INTEGER ) is
            -- Hintergrund auf farbe einstellen

        external "C"
        alias "c_textbackground"

        end

-----------------------------------------------------------

    textcolor ( farbe : INTEGER ) is
            -- Schriftauf farbe  einstellen

        external "C"
        alias "c_textcolor"

        end

-----------------------------------------------------------

-----------------------------------------------------------

    scrolling is
            -- Scrolling einschalten

        external "C"
        alias "c_scrolling"

        end

-----------------------------------------------------------

    no_scrolling is
            -- Scrolling abschalten

        external "C"
        alias "c_no_scrolling"

        end

-----------------------------------------------------------

end -- class DOS
