#include "c:\e\run3\eiffel.h"
#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

/*
---------------------------------------------------------
-- Grafikmodul                                  EIFFEL --
--                                                     --
-- c_initgraph          Initialisierung der Grafik     --
-- c_closegraph         Beenden des Grafikmodus        --
--                                                     --
-- c_setcolor           Farbe           definieren     --
-- c_setfillstyle       Fllmuster      definieren     --
--                                                     --
-- c_outtextxy          Text            schreiben      --
-- c_textheight         Texthhe        ermitteln      --
-- c_textwidth          Textbreite      ermitteln      --
-- c_settextstyle       Schriftart      definieren     --
-- c_settextjustify     Schriftanschlag definieren     --
-- c_setusercharsize    Schriftgre    definieren     --
--                                                     --
-- c_putpixel           Pixel           schreiben      --
-- c_line               Linie           zeichnen       --
-- c_ellipse            Ellipsenbogen   zeichnen       --
-- c_fillellipse        Vollellipse     zeichnen       --
-- c_circle             Kreislinie      zeichnen       --
-- c_rectangle          Rechteck        zeichnen       --
-- c_bar                Vollrechteck    zeichnen       --
-- drawpoly             Polygon         zeichnen       --
-- fillpoly             Polygon         fllen         --
--                                                     --
---------------------------------------------------------
-- Autor   : Dr. P.G. Zint                             --
-- Datum   : 16. Juli 1992                             --
-- Version : 1.0                                       --
---------------------------------------------------------
*/


/*---------------------------------------------------------*/

BOOLEAN c_initgraph ( Current , bgi_path )

OBJREF  Current ;
OBJREF  bgi_path ;

{

CHARACTER *str ;
int gdriver = DETECT, gmode, errorcode; /* request auto detection */

str       = RSTR_seq ( bgi_path ) ;
initgraph ( &gdriver , &gmode , str ) ;
errorcode = graphresult ( ) ;

return ( errorcode == grOk ? true : false ) ;

}

/*---------------------------------------------------------*/

void c_closegraph ( Current )

OBJREF  Current ;

{

closegraph ( ) ;

}

/*---------------------------------------------------------*/

void c_setcolor ( Current , farbe )

OBJREF  Current ;
INTEGER farbe ;

{

setcolor ( farbe ) ;

}

/*---------------------------------------------------------*/

void c_setfillstyle ( Current , muster , farbe )

OBJREF  Current ;
INTEGER muster , farbe  ;

{

setfillstyle ( muster , farbe ) ;

}

/*---------------------------------------------------------*/

/*---------------------------------------------------------*/

void c_outtextxy ( Current , x , y , text )

OBJREF  Current ;
OBJREF  text ;
INTEGER x , y ;

{
CHARACTER *str ;

str       = RSTR_seq ( text ) ;
outtextxy ( x , y , str ) ;

}

/*---------------------------------------------------------*/

INTEGER c_textheight ( Current , text )

OBJREF  Current ;
OBJREF  text ;

{
CHARACTER *str ;

str = RSTR_seq ( text ) ;
return (INTEGER) textheight ( str ) ;

}

/*---------------------------------------------------------*/

INTEGER c_textwidth ( Current , text )

OBJREF  Current ;
OBJREF  text ;

{
CHARACTER *str ;

str = RSTR_seq ( text ) ;
return (INTEGER) textwidth ( str ) ;

}

/*---------------------------------------------------------*/

/*---------------------------------------------------------*/
void c_settextstyle ( Current , stil , richtung , groesse )

OBJREF  Current ;
INTEGER stil , richtung , groesse ;

{

settextstyle ( stil , richtung , groesse ) ;

}

/*---------------------------------------------------------*/

void c_settextjustify ( Current , horizontal , vertikal )

OBJREF  Current ;
INTEGER horizontal , vertikal ;

{

settextjustify ( horizontal , vertikal ) ;

}

/*---------------------------------------------------------*/

void c_setusercharsize ( Current , multx , divx , multy , divy )

OBJREF  Current ;
INTEGER multx , divx , multy , divy ;

{

setusercharsize ( multx , divx , multy , divy ) ;

}

/*---------------------------------------------------------*/

/*---------------------------------------------------------*/

void c_putpixel ( Current , x , y , farbe )

OBJREF  Current ;
INTEGER x , y ;

{

putpixel ( x , y , farbe ) ;

}

/*---------------------------------------------------------*/

void c_line ( Current , x1 , y1 , x2 , y2 )

OBJREF  Current ;
INTEGER x1 , y1 , x2 , y2 ;

{

line ( x1 , y1 , x2 , y2 ) ;

}

/*---------------------------------------------------------*/

/*---------------------------------------------------------*/

void c_ellipse ( Current , x , y , von_winkel , bis_winkel , a , b )

OBJREF  Current ;
INTEGER x , y , von_winkel , bis_winkel , a , b ;

{

ellipse ( x , y , von_winkel , bis_winkel , a , b ) ;

}

/*---------------------------------------------------------*/

void c_fillellipse ( Current , x , y , a , b )

OBJREF  Current ;
INTEGER x , y , a , b ;

{

fillellipse ( x , y , a , b ) ;

}

/*---------------------------------------------------------*/

void c_circle ( Current , x , y , radius )

OBJREF  Current ;
INTEGER x , y , radius ;

{

circle  ( x , y , radius ) ;

}

/*---------------------------------------------------------*/

void c_rectangle ( Current , links , oben , rechts , unten )

OBJREF  Current ;
INTEGER links , oben , rechts , unten ;

{

rectangle ( links , oben , rechts , unten ) ;

}

/*---------------------------------------------------------*/

void c_bar ( Current , links , oben , rechts , unten )

OBJREF  Current ;
INTEGER links , oben , rechts , unten ;

{

bar ( links , oben , rechts , unten ) ;

}
/*---------------------------------------------------------*/

/*---------------------------------------------------------*/

void c_drawpoly ( Current , ecken )

OBJREF  Current ;
OBJREF  ecken ;

{
INTEGER i , size ;
INTEGER *ip ;
int polygon [ 50 ] ;

size =             RARR_size ( ecken ) ;
ip   = (INTEGER *) RARR_seq  ( ecken ) ;

if ( ip != (INTEGER *) NULL )
  {
  for ( i = 0 ; i < size ; ++i , ++ip )
    polygon [ i ] = (int) *ip ;
  drawpoly ( size / 2 , polygon ) ;
  }

}

/*---------------------------------------------------------*/

void c_fillpoly ( Current , ecken )

OBJREF  Current ;
OBJREF  ecken ;

{
INTEGER i , size ;
INTEGER *ip ;
int polygon [ 50 ] ;

size =             RARR_size ( ecken ) ;
ip   = (INTEGER *) RARR_seq  ( ecken ) ;

if ( ip != (INTEGER *) NULL )
  {
  for ( i = 0 ; i < size ; ++i , ++ip )
    polygon [ i ] = (int) *ip ;
  fillpoly ( size / 2 , polygon ) ;
  }

}
