-----------------------------------------------------------
-- GRAFIK                                       Eiffel 3 --
--                                                       --
--  Auswahl von Grafik-Features auf BORLAND-C-Basis      --
--                                                       --
--  fr Anwender, die TURBO   PASCAL und/oder            --
--                    TURBO   C      und/oder            --
--                    Borland C                          --
--  kennen.                                              --
--                                                       --
-----------------------------------------------------------
--                                                       --
-- Autor   : Dr. P.G. Zint                               --
-- Datum   : 31. August 1992                             --
-- Version : 1.0                                         --
--                                                       --
-----------------------------------------------------------

class   GRAFIK  

feature {ANY} -- Attribute

	Default_font	: INTEGER is 0
	Triplex_font	: INTEGER is 1
	Small_font	: INTEGER is 2
	Sans_serif_font : INTEGER is 3
	Gothic_font	: INTEGER is 4

        Horiz_dir	: INTEGER is 0  -- left to right
        Vert_dir	: INTEGER is 1	-- bottom to top

	Left_text	: INTEGER is 0
	Center_text	: INTEGER is 1
	Right_text	: INTEGER is 2
	Bottom_text	: INTEGER is 0
	Top_text	: INTEGER is 2

-- Fllmuster
        Empty_fill      : INTEGER is  0 -- Hintergrundfarbe
        Solid_fill      : INTEGER is  1 -- einheitliche Flche
        Line_fill       : INTEGER is  2 -- ---
        Ltslash_fill    : INTEGER is  3 -- ///
        Slash_fill      : INTEGER is  4 -- /// mit dicken Linien
        Bkslash_fill    : INTEGER is  5 -- \\\ mit dicken Linien
        Ltbkslash_fill  : INTEGER is  6 -- \\\
        Hatch_fill      : INTEGER is  7 -- leicht schraffiert
        Xhatch_fill     : INTEGER is  8 -- stark schraffiert
        Interleave_fill : INTEGER is  9 -- abwechselnde Linien
        Wide_dot_fill   : INTEGER is 10 -- Punkte, weit auseinander
        Close_dot_fill  : INTEGER is 11 -- Punkte dicht
        User_fill       : INTEGER is 12 -- benutzerdefiniert


feature {ANY} -- Initialisieren und Beenden

-------------------------------------------------------------------------

    initgraph ( bgi_path : STRING ) : BOOLEAN is
            -- Grafikmodus initialisieren

        external "C"
        alias "c_initgraph"

        end

-------------------------------------------------------------------------

    closegraph is
            -- Grafikmodus beenden

        external "C"
        alias "c_closegraph"

        end

-------------------------------------------------------------------------

feature {ANY} -- Definieren der Grafik-Parameter

-------------------------------------------------------------------------

    setcolor ( farbe : INTEGER ) is
            -- Farbe definieren

        external "C"
        alias "c_setcolor"

        end

-------------------------------------------------------------------------

    setfillstyle ( muster , farbe : INTEGER ) is
            -- Fllmuster definieren

        external "C"
        alias "c_setfillstyle"

        end

-------------------------------------------------------------------------

feature {ANY} -- Textbehandlung

-------------------------------------------------------------------------

    outtextxy ( x , y : INTEGER ; text : STRING ) is
            -- Text schreiben

        external "C"
        alias "c_outtextxy"

        end

-------------------------------------------------------------------------

    textheight ( text : STRING ) : INTEGER is
            -- Texthhe von Text ermitteln

        external "C"
        alias "c_textheight"

        end

-------------------------------------------------------------------------

    textwidth ( text : STRING ) : INTEGER is
            -- Textbreite von Text ermitteln

        external "C"
        alias "c_textwidth"

        end

-------------------------------------------------------------------------

    settextjustify ( horizontal , vertikal : INTEGER ) is
            -- Schriftanschlag definieren

        external "C"
        alias "c_settextjustify"

        end

-------------------------------------------------------------------------

    settextstyle ( stil , richtung , groesse : INTEGER ) is
            -- Schriftart definieren

        external "C"
        alias "c_settextstyle"

        end

-------------------------------------------------------------------------

    setusercharsize ( multx , divx , multy , divy : INTEGER ) is
            -- Schriftgre definieren

        external "C"
        alias "c_setusercharsize"

        end

-------------------------------------------------------------------------

feature {ANY} -- Grafiksymbole darstellen

-------------------------------------------------------------------------

    putpixel ( x , y , farbe : INTEGER ) is
            -- Pixel in Farbe bei (x, y) schreiben

        external "C"
        alias "c_putpixel"

        end

-------------------------------------------------------------------------

    line ( x1 , y1 , x2 , y2 : INTEGER ) is
            -- Linie von (x1, y1) nach (x2, y2) zeichnen

        external "C"
        alias "c_line"

        end

-------------------------------------------------------------------------

    ellipse ( x , y , von_winkel , bis_winkel , a , b : INTEGER ) is
            -- Ellipsenrand von von_winkel bis bis_winkel zeichnen
            -- mit Halbachsen a, b

        external "C"
        alias "c_ellipse"

        end

-------------------------------------------------------------------------

    fillellipse ( x , y , a , b : INTEGER ) is
            -- Vollellipse zeichnen mit Halbachsen a, b

        external "C"
        alias "c_fillellipse"

        end

-------------------------------------------------------------------------

    circle ( x , y , radius : INTEGER ) is
            -- Kreislinie um (x, y) mit radius zeichnen

        external "C"
        alias "c_circle"

        end

-------------------------------------------------------------------------

    rectangle ( links , oben , rechts , unten : INTEGER ) is
            -- Rechteckrand von (links,oben) bis (rechts,unten) zeichnen

        external "C"
        alias "c_rectangle"

        end

-------------------------------------------------------------------------

    bar ( links , oben , rechts , unten : INTEGER ) is
            -- Vollrechteck von (links,oben) bis (rechts,unten) zeichnen

        external "C"
        alias "c_bar"

        end

-------------------------------------------------------------------------

-------------------------------------------------------------------------

    drawpoly ( ecken : ARRAY [ INTEGER ] ) is
            -- Polygon zeichnen

        require
             ecken.size >=  1 ;
             ecken.size <= 50

        external "C"
        alias "c_drawpoly"

        end

-------------------------------------------------------------------------

    fillpoly ( ecken : ARRAY [ INTEGER ] ) is
            -- Polygon fllen

        require
             ecken.size >=  1 ;
             ecken.size <= 50

        external "C"
        alias "c_fillpoly"

        end

-------------------------------------------------------------------------

end -- class GRAFIK
