-----------------------------------------------------------
-- TEXTDATEI                                  Eiffel 3   --
--                                                       --
-- Features zu ffnen, Schreiben, Lesen und Schlieen    --
-- von unstrukturierten oder zeilenorientierten          --
-- Textfiles                                             --
--                                                       --
-- (fr Anwender, die PASCAL kennen)                     --
--                                                       --
-----------------------------------------------------------
--                                                       --
-- Autor   : Dr. P.G. Zint                               --
-- Datum   : 31. August 1992                             --
-- Version : 1.0                                         --
--                                                       --
-----------------------------------------------------------

class   TEXTDATEI

creation
    make

feature {ANY}

    open : BOOLEAN

    hook : INTEGER
    size : INTEGER
    nr   : INTEGER
    c    : CHARACTER
    line : INTEGER
    fs   : FILE_SYSTEM
    f    : FILE [CHARACTER]

    Cr   : CHARACTER is '%/13/'
    Lf   : CHARACTER is '%N'

---------------------------------------------------------

    make is
        do
            !!fs.make 
        end

---------------------------------------------------------

    openread ( datei : STRING ) : BOOLEAN is
            -- Ist Datei zum Lesen (und Schreiben) offen ?
        require
            textfile_open_read : NOT open 
        do
            if fs.file_exists  ( datei ) and then
               fs.has_readperm ( datei )     then 
                    hook  := fs.access_file ( datei , "rw", false)
                    !!f.connect_to (hook)
                    open  := TRUE
                    nr    := 1
                    size  := f.size
                    line  := 1
            end
            Result := open 
        end
        
---------------------------------------------------------

    openwrite ( datei : STRING ) : BOOLEAN is
            -- Ist Datei zum Schreiben (und Lesen) offen ?
        require
            textfile_open_write : NOT open 
        do
            if NOT fs.file_exists  ( datei ) then
                   fs.add_file ( datei , "rwx.r-x.--x" )
            end
            if fs.has_writeperm ( datei ) then 
                hook  := fs.access_file ( datei , "rw", true)
                !!f.connect_to (hook)
                open  := TRUE
                nr    := 1
                line  := 1
            end
            Result := open 
        end
        
---------------------------------------------------------

---------------------------------------------------------

    end_of_file : BOOLEAN is
            -- Ist das Dateiende erreicht ?
        require
            textfile_eof : open 
        do
            Result := nr > size
        end
        
---------------------------------------------------------

    closefile is
            -- Datei schlieen
        require
            textfile_close : open 
        do
            f.disconnect
            open  := FALSE
        ensure
            NOT open
        end
        
---------------------------------------------------------

---------------------------------------------------------

    get_char : CHARACTER is
            -- Ein Zeichen lesen
        require
            textfile_gc : open and not end_of_file
        do
            c  := f.item ( nr )
            nr := nr + 1
            if c = Lf then line := line + 1 end
            Result := c
        ensure
            nr = old nr + 1
        end
        
---------------------------------------------------------

    put_char ( ch : CHARACTER ) is
            -- Ein Zeichen schreiben
        require
            textfile_pc : open -- und gengend FILE-Kapazitt vorhanden
        do
            f.put ( ch , nr )
            nr := nr + 1
            if ch = Lf then line := line + 1 end
        ensure
            nr = old nr + 1
        end
        
---------------------------------------------------------

---------------------------------------------------------

    put_string ( text : STRING ) is
            -- Einen Zeichenstring schreiben
        require
            textfile_ps : open -- und gengend FILE-Kapazitt vorhanden
        local
            s : INTEGER
        do
            from
                s := 1
            until
                s > text.count
            loop
                put_char ( text.item(s) )
                s := s + 1
            end
        end
        
---------------------------------------------------------

    writeln ( text : STRING ) is
            -- Einen Zeichenstring und eine neue Zeile schreiben
        require
            textfile_wln : open -- und gengend FILE-Kapazitt vorhanden
        do
            put_string ( text ) ;
            put_newline
        end
        
---------------------------------------------------------

    put_newline is
            -- Eine Zeile schreiben
        require
            textfile_nl : open -- und gengend FILE-Kapazitt vorhanden
        do
            put_char ( Cr )
            put_char ( Lf )
        end
        
---------------------------------------------------------

---------------------------------------------------------

    readln : STRING is
            -- Zeichenstring lesen
        require
            textfile_rln : open and not end_of_file
        local
            s : STRING
        do
            from
                !!s.make ( 0 )
            until
                ( s.count > 0 and then s.item (s.count) = Lf ) or
                end_of_file
            loop
                s.insert ( get_char , s.count )
            end
            if s.count > 0 and then s.item ( s.count ) = Lf then
                s.remove ( s.count )
                if s.count > 0 and then s.item ( s.count ) = Cr then
                   s.remove ( s.count )
                end
            end
            Result := s
        ensure
                Result.item ( Result.count ) /= Lf
                -- Result enthlt nicht die Zeichen Cr/Lf der Zeilenschaltung
                ( line = old line + 1 ) or else end_of_file
        end
        
---------------------------------------------------------

end -- class TEXTDATEI
