class BINCOPY

creation
  main

feature
 
c:           STREAMIO

main is   
  local
    cnt:     INTEGER
    s, d:    STREAMIO
    sn, dn:  STRING
    env:     ENVIRON
    f:       FILE_SYSTEM
    fmt:     FORMAT
  do
    !!c.open ("stdio", "rw")

    -- read parameter string
    !!env
    if env.arg_count /= 2 then
      error ("use", "bincopy source destination")
    end
    sn := env.arg_item (1)
    dn := env.arg_item (2)

    -- check files
    !!f.make
    if not f.file_exists (sn) then
      error ("can not find source file", sn)
    end
    if f.file_exists (dn) then
      c.put_string ("destination exists - continue ? (y/n)")
      c.get_char
      if c.last_char /= 'y' then
        error ("cancel", " ")
      end -- if
    end -- if

    -- perform binary copy
    from
      !!s.open (sn, "rb")
      s.get_char
      !!d.open (dn, "wb")
    until
      s.end_of_input
    loop
      d.put_char (s.last_char)
      s.get_char
      cnt := cnt + 1
    end -- loop
    !!fmt
    c.put_string ("total number of chars was ")
    c.put_string (fmt.i2s ("8", cnt))
    c.put_newline

  end -- make

error (s, t: STRING) is
  local
    err: EXCEPT
  do
    c.put_string(s)
    c.put_string ("  ")
    c.put_string(t)
    c.put_newline
    !!err
    err.raise ("bincopy", "error condition", 0, current)
  end

end -- class
      
