/* C support for STREAMIO.E
                                */
#include <stdio.h>

#include "test.p\eiffel.h"
#include "streamio.h"

extern  CHARACTER  *RSTR_seq (OBJREF);

char streamio [] = "streamio";

FILE * stdio;    /* dummy declaration */

OBJREF STRM_open_file (current, tp, n, m)
  OBJREF current;
  INTEGER tp;
  OBJREF n, m;
  {
  FILE *tmp;
  switch ((int)tp)
    {
    case 1: tmp = stdout;
      break;
    case 2: tmp = stdin;
      break;
    case 3: tmp = stderr;
      break;
    case 4: tmp = stdio;
      break;
    case 5:
      tmp = fopen (RSTR_seq (n), RSTR_seq (m));
      if (tmp == NULL) RXM_raise (streamio, "open", 0, current); 
      break;
      };
  return (OBJREF) tmp;
  }

STRM_close_file (current)
  OBJREF current;
  {
  FILE *tmp;
  tmp = (FILE *)((ECA_streamio *) current) -> Efile_ptr;
  if ( fclose (tmp) != 0) RXM_raise (streamio, "close", 0, current); 
  }

STRM_put_char (current, ch)
  OBJREF current;
  CHARACTER ch;
  {
  FILE *tmp;
  tmp = (FILE *)((ECA_streamio *) current) -> Efile_ptr;
  if (tmp == stdio) tmp = stdout;
  fputc (ch, tmp); 
  }

STRM_put_newline (current)
  OBJREF current;
  {
  FILE *tmp;
  tmp = (FILE *)((ECA_streamio *) current) -> Efile_ptr;
  if (tmp == stdio) tmp = stdout;
  fputc ('\n', tmp); 
  }

STRM_put_string (current, str)
  OBJREF current, str;
  {
  FILE *tmp;
  tmp = (FILE *)((ECA_streamio *) current) -> Efile_ptr;
  if (tmp == stdio) tmp = stdout;
  fputs (RSTR_seq (str), tmp); 
  }

STRM_get_char (current)
  OBJREF current;
  {
  FILE *tmp;
  CHARACTER ch;
  tmp = (FILE *)((ECA_streamio *) current) -> Efile_ptr;
  if (tmp == stdio) tmp = stdin;
  ch = (CHARACTER) fgetc (tmp);
  ((ECA_streamio *) current) -> Elast_char = ch;  
  }

BOOLEAN STRM_end_of_input (current)
  OBJREF current;
  {
  FILE *tmp;
  tmp = (FILE *)((ECA_streamio *) current) -> Efile_ptr;
  if (tmp == stdio) tmp = stdin;
  return (BOOLEAN) feof (tmp);
  }


