class NAM_LIST

-- Verwaltet die Namen

   inherit
      NAM_USER

   creation
      make

   feature 

      is_reserved,
      is_ident,
      is_string:        INTEGER is unique;

      identifier_type,
      identifier_code:  INTEGER;  -- results of find_type 

      make is
         do
            !!res_list.make (true);
            init_symbols
         end

      find_type (s: STRING) is

         require
            parameter_ok: s /= void

         do
            res_list.search (s);
            if res_list.found then
               identifier_type := is_reserved;
               identifier_code := res_list.found_item;
            else
               identifier_type := is_ident
            end -- if 
         end -- find_type 

   ----------------------------------------------

   feature {NONE}

      res_list: SORTED_TABLE [STRING, INTEGER];
      -- store all reserved identifiers  

      dcl (a: ARRAY [ANY]) is

         local
            s: STRING;
            i: INTEGER_REF,
            ptr: INTEGER;

         do
            from
               ptr := a.lower
            until 
               ptr > a.upper
            loop
               i ?= a @ ptr;
               s ?= a @ (ptr +1);
               if s /= void and then i /= void then
                  res_list.add (i.item, s);
               end;
               ptr := ptr + 2;
            end -- loop      
         end -- dcl       

      init_symbols is

         do
            dcl (<< res.s_becomes, ":=",
            res.s_not_equal, "/=",
            res.s_greater_equal,">=",
            res.s_less_equal, "<=">>);

            dcl (<< res.s_alias, "alias",
            res.s_all, "all",
            res.s_and, "and",
            res.s_as, "as",
            res.s_check, "check",
            res.s_class, "class",
            res.s_creation, "creation",
            res.s_debug, "debug",
            res.s_deferred, "deferred",
            res.s_define, "define",
            res.s_do, "do",
            res.s_else, "else",
            res.s_elseif, "elseif",
            res.s_end, "end",
            res.s_ensure, "ensure",
            res.s_expanded, "expanded",
            res.s_export, "export",
            res.s_external, "external",
            res.s_false, "false">>);

            dcl (<< res.s_feature, "feature",
            res.s_from, "from",
            res.s_feature, "feature",
            res.s_from, "from",
            res.s_frozen, "frozen",
            res.s_if, "if",
            res.s_implies, "implies",
            res.s_indexing, "indexing",
            res.s_infix, "infix",
            res.s_inherit, "inherit",
            res.s_inspect, "inspect",
            res.s_invariant, "invariant",
            res.s_is, "is",
            res.s_like, "like",
            res.s_local, "local",
            res.s_loop, "loop",
            res.s_obsolete, "obsolete",
            res.s_old, "old",
            res.s_once, "once",
            res.s_or, "or">>);

            dcl (<< res.s_prefix, "prefix",
            res.s_redefine, "redefine",
            res.s_rename, "rename",
            res.s_require, "require",
            res.s_rescue, "rescue",
            res.s_result, "result",
            res.s_retry, "retry",
            res.s_select, "select",
            res.s_separate, "separate",
            res.s_strip, "strip",
            res.s_then, "then",
            res.s_true, "true",
            res.s_undefine, "undefine",
            res.s_unique, "unique",
            res.s_until, "until",
            res.s_variant, "variant",
            res.s_when, "when",
            res.s_xor, "xor">>);
         end;

      end -- class     
