class PRINTER

   inherit
      IO_USER
      NAM_USER

   feature

      act_h_position,
      act_v_position,
      left,
      empty_lines,
      tab_size:   INTEGER;    
      tab_string: STRING;
      -------------------

      set_tab (s: STRING) is
         require
            s /= void
         do
            tab_string := clone (s)
         end;
      -------------------

      new_line_abs (p: INTEGER) is

         require
            p > 0

         do
            left := p;
            new_line (false);
         end;

      new_line_rel (p: INTEGER) is

         do
            left := left + p;

            new_line (false);
         end;

      new_line (extern: BOOLEAN) is
         do
            if act_h_position /= 1 or extern then
               if act_v_position > 0 then
                  io.put_char ('%N');
               end;
               act_h_position := 1;
               act_v_position := act_v_position + 1;
            end;
         end;
      -------------------

      inc_left (p: INTEGER) is
         do
            left := left + p;
         end;
      -------------------

      out (s: STRING) is
         require
            s /= void
         do
            if act_h_position = 1 then
               tab (left)
               act_h_position := left
            end -- if        
            io.put_string (s);
            act_h_position := act_h_position + 1;
            empty_lines := 0;
         end;
      -------------------

      tab (anz: INTEGER) is
         local
            i: INTEGER
         do
            from
               i := 1
            until
               i >= anz
            loop
               io.put_string (tab_string);
               i := i + 1
            end;
         end;

   end -- class     
