class SPRETTY

   inherit
      NAM_USER
      SC_USER
      GL_USER

   creation 
      make

   feature 

      scan :    SCANNER;
      nl :      NAM_LIST;
      or_else:  BOOLEAN
      act_token:STRING;
      ----------------

      make is
         do
            !!scan.make (1)
            !!nl.make
            --
            initialize;
            action
         end -- main      
      ----------------

      action is
         do
            from
               scan.get_token
            until
               scan.end_of_input
            loop
               act_token := scan.last_token.text;
               --
               inspect 
                  scan.last_token.type
               when sc.line then
                  special_action (res.is_newline)
               when sc.comment then
                  special_action (res.is_default)
               when sc.ident then
                  identifier
               when sc.space then
                  special_action (res.is_blank)
               when sc.symb then
                  special_action (res.is_default) 
               else -- inspect   
                  special_action (res.is_default) 
                  -- no extra commands    
               end -- inspect              
               ------------------------
               scan.get_token
            end -- loop      
         end -- action    
      ----------------

      identifier is
         local
            t: STRING;
         do
            -- convert to lower case
            t := clone (scan.last_token.text);
            t.to_lower;
            nl.find_type (t);
            --
            if nl.identifier_type = nl.is_reserved and then
               list.item (nl.identifier_code) /= void then
               inspect nl.identifier_code 
               when res.s_deferred then
                  if gc.state < gc.st_class then
                     special_action (res.s_deferred_class)
                  else
                     special_action (res.s_deferred)
                  end -- if        
               when res.s_else then
                  if or_else then
                     special_action (res.is_default)
                  else
                     special_action (res.s_else)
                  end -- if        
               when res.s_or then
                  or_else := true
                  special_action (nl.identifier_code)
               else -- inspect   
                  special_action (nl.identifier_code)
                  or_else := false
               end -- inspect   
            else
               special_action (res.is_default)
            end -- if        
         end -- identifier
      ----------------

      initialize is
         local
            t: SYMBOL
         do
            !!list.make (0, 100);
            --
            -- special entries      
            !newline!t.make (false, false, 0, 0);
            list.force (t, res.is_newline);
            !blank!t.make (false, false, 0, 0);
            list.force (t, res.is_blank);
            !s_end!t.make (true, false, -1, 0);
            list.force (t, res.s_end);
            set_state (res.s_end, 0, gc.st_feature_header); 
            --
            set (res.is_default, false, false, 0, 0);
            --
            -- standard Eiffel token
            set (res.s_or, false, false, 0, 0);
            set (res.s_indexing, true, true, gc.class_pos, 1);
            set (res.s_class, true, true, gc.class_pos, 0);
            set_state (res.s_class, gc.st_class, 0);
            --
            set (res.s_feature, true, true, gc.feature_pos, 1);
            set_state  (res.s_feature, gc.st_feature, gc.st_feature_header);
            --
            set (res.s_invariant, true, false, -1, 1);
            set (res.s_inherit, true, true, gc.inherit_pos, 1);
            set (res.s_define, true, true, gc.inherit_pos + 2, 0);
            duplicate (res.s_redefine, res.s_define);
            duplicate (res.s_rename, res.s_define);
            duplicate (res.s_select, res.s_define);
            duplicate (res.s_undefine, res.s_define);
            duplicate (res.s_export, res.s_define);
            --
            set (res.s_creation, true, true, gc.feature_pos, 1);
            set (res.s_do, true, true, gc.do_pos, 1);
            set_state (res.s_do, 0, gc.st_feature_body);
            duplicate (res.s_external, res.s_do);
            duplicate (res.s_once, res.s_do);
            duplicate (res.s_local, res.s_do);
            duplicate (res.s_ensure, res.s_do);
            duplicate (res.s_rescue, res.s_do);
            --
            duplicate (res.s_deferred, res.s_do);
            set (res.s_deferred_class, true, true, gc.class_pos, 0);
            set (res.s_expanded, true, true, gc.class_pos, 0);
            set (res.s_require, true, true, gc.do_pos, 1);
            set (res.s_debug, true, false, 0, 1);
            set (res.s_if, true, false, 0, 1);
            set (res.s_from, true, false, 0, 1);
            set (res.s_elseif, true, false, -1, 1);
            set (res.s_loop, true, false, -1, 1);
            set (res.s_else, true, false, -1, 1);
            set (res.s_until, true, false, -1, 1);
            set (res.s_inspect, true, false, 0, 1);
            set (res.s_when, true, false, -1, 1);
         end
      ----------------

      set (token: INTEGER; new_line, abs_pos: BOOLEAN; inc_bef, inc_aft: INTEGER) is
         require
            abs_pos implies (inc_bef >= 0) and (inc_aft >= 0)
         local
            t: SYMBOL
         do
            !!t.make (new_line, abs_pos, inc_bef, inc_aft);
            list.force (t, token)
         end
      ----------------

      duplicate (new_token, old_token: INTEGER) is
         require
            list.item (old_token) /= void
         do
            list.force (list.item (old_token), new_token)
         end
      ----------------

      set_state (token, stat, substat: INTEGER) is
         require
            list.item (token) /= void
         do
            list.item (token).set_state (stat, substat)
         end;
      ----------------

      special_action (i: INTEGER) is
         require
            list.item (i) /= void
         do
            list.item (i).print (act_token)
            list.item (i).change_state
         end;
      ----------------

      list: ARRAY [SYMBOL];        

   end -- class     
