class SYMBOL

   inherit
      GL_USER

   creation
      make;

   feature
      new_line_before,
      new_line_after,
      next_state_available,
      next_substate_available,
      abs_pos:    BOOLEAN

      next_state,
      next_substate,
      pos_before,
      pos_after:  INTEGER
      -----------------

      make (n_line, n_pos: BOOLEAN; pos_b, pos_a: INTEGER) is
         do
            new_line_before := n_line;
            abs_pos := n_pos;
            pos_before := pos_b;
            pos_after := pos_a
         end;
      -----------------

      set_state (stat, substat: INTEGER) is
         do
            if stat > 0 then
               next_state := stat;
               next_state_available := true
            end -- if        
            if substat > 0 then
               next_substate := substat;
               next_substate_available := true
            end -- if        
         end

      change_state is
         do
            if next_state_available then
               gc.change_state (next_state)
            end
            if next_substate_available then
               gc.change_substate (next_substate)
            end
         end
      -----------------

      print (s: STRING) is
         require
            s /= void
         do
            if new_line_before then
               if abs_pos then
                  p.new_line_abs (pos_before)
               else
                  p.new_line_rel (pos_before);
               end -- if        
            end -- if        
            p.out (s);
            if new_line_after then
               p.new_line_rel (pos_after)
            else
               p.inc_left (pos_after)
            end -- if        
         end -- print     

      p: PRINTER is
         once
            !!Result;
            Result.set_tab (gc.tab_const)
         end

   end -- SYMBOL    
