class SCANNER

   inherit 
      SC_USER  

   creation make

   feature {ANY}

      make (l: INTEGER) is
      -- l is the number of maximal lookaheads      

         require
            lookahead : l >= 1

         local
            i: INTEGER

         do
            !!queue.make (1, l)
            put_ptr := 1 
            get_ptr := 0 
            from
               i := 1
            until
               i > l - 1
            loop
               next 
               into_queue
               i := i+1
            end -- loop      
         end -- make      
   -----------

      last_token: TOKEN is
      -- delivers the reference to the next token   

         do
            Result := queue.item (get_ptr)
         end
   -----------

      lookahead_token (i: INTEGER): TOKEN is
      -- delivers the reference to the token        
      -- with i lookahead     

         require
            lookahead_positive: i < 0
            lookahead_korrect: i <= queue.size

         local
            ptr: INTEGER

         do
            ptr := get_ptr + i
            if ptr > queue.size then
               ptr := ptr - queue.size
            end -- if        
            Result := queue.item (ptr)
         end
   ---------

      get_token is
      -- read next token, removes next entry        
      -- from the lookahead queue        

         do
            next
            into_queue
            get_ptr := get_ptr + 1
            if get_ptr > queue.size then
               get_ptr := 1
            end -- if        
         end
   ------------

      end_of_input: BOOLEAN is
      -- end of input in the input stream

         do
            Result := last_token.type = sc.eof
         end
   ------------------------------------------------------------------------

   feature {NONE}

      queue:  ARRAY [TOKEN]

      put_ptr,
      get_ptr:    INTEGER
      act_token:  TOKEN

      next is

         do
            if input.end_of_input then
               !t_eof!act_token
            else

               inspect sc.char_type (input.last_char)
               when  sc.letter then  !t_ident!act_token
               when  sc.digit then   !t_number!act_token
               when  sc.quote then   !t_string!act_token   
               when  sc.space then   !t_space!act_token
               when  sc.newline then !t_line!act_token
               else                  !t_symb!act_token
               end -- inspect   
            end -- if        
            --
            act_token.get_token
            act_token.strip_text
            act_token.action 
         end -- next      

      into_queue is

         do
            queue.put (act_token, put_ptr)
            put_ptr := put_ptr + 1
            if put_ptr > queue.size then
               put_ptr := 1
            end -- if        
         end -- procedure 

   end -- class scanner        
