class SC_CONST

   feature {ANY}

      -- constants 

      letter,     -- types of characters  
      apo,
      digit,
      underline,
      newline,
      quote,
      bracket,
      other:      INTEGER is unique

      ident,      -- types of lexical tokens         
      number,     --  (first level)       
      text,
      space,
      line,
      symb,
      comment,
      eof:        INTEGER is unique

      char_type (ch: CHARACTER): INTEGER is

         do

            inspect ch
            when 'a'..'z' then
               Result := letter
            when 'A'..'Z' then
               Result := letter
            when '0'..'9' then
               Result := digit
            when '_' then
               Result := underline
            when ' ', '%T' then
               Result := space
            when '%N', '%R' then
               Result := newline
            when '%'', '%"' then
               Result := quote
            when '(', ')', '[', ']', '{', '}' then
               Result := bracket
            else
               Result := other
            end -- inspect   
         end -- do        

   end -- class        
