-- Option matcher that checks against characters.

indexing
	
	type: skeleton;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 20:03:34 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: CHARMAT.E $
	-- Revision 1.2  1993/06/24  20:03:34  Neil_Wilson
	-- Altered format of help message
	--
	-- Revision 1.1  1993/06/20  12:36:09  Neil_Wilson
	-- Initial revision
	-- 

deferred class CHARACTER_MATCHER

inherit
		
	ALTERABLE_MATCHER

feature -- Option list manipulators         
	
	is_present (opt: STRING): BOOLEAN is
		--  Check whether an option is on the match list.
	do
		search (opt)
		Result := simple_found or optional_found or parameter_found
	end -- is_present

	add (opt: STRING) is
		-- Add a simple option to the match list.     
	local
		i: INTEGER
	do
		from
			i := 1
		variant
			string_scan: opt.count - i + 1
		until
			i > opt.count
		loop
			simple.add (opt.substring (i, i));
			i := i + 1		
	    	end
	end -- add       
		
	add_required (opt: STRING, parameter_name: STRING) is
		-- Add option with required parameter to match list.     
		-- Parameter_name is used in the help list.   
	local
		i: INTEGER
	do
		from
			i := 1
		variant
			string_scan: opt.count - i + 1
		until
			i > opt.count
		loop
			if parameter_name /= Void then
				param_list.add (parameter_name, opt.substring (i, i));
			else
				param_list.add (default_parameter_name, opt.substring (i, i));
			end;
		    	i := i + 1
		end
	end -- add_required         

	add_optional (opt: STRING, parameter_name: STRING) is
		-- Add option with optional parameter to match list.     
		-- Parameter_name is used in the help list.   
	local
		i: INTEGER
	do
		from
			i := 1
		variant
			string_scan: opt.count - i + 1
		until
			i > opt.count
		loop
			if parameter_name /= Void then
				optional_list.add (parameter_name, opt.substring (i, i));
			else
				optional_list.add (default_parameter_name, opt.substring (i, i));
			end
			i := i + 1
		end
	end -- add_optional         
	
	help: STRING is
		-- Character option help listing.
	local
		it: ITERATOR;
		build: like help;
	do
		!!build.make (0);
		!!Result.make (0);
		from
			it := simple.iterator
		until
			it.finished
		loop
			build.append (simple.item (it))
			it.forth
		end;
		if not build.empty then
			Result.append ("[");
			Result.append (add_option_marker(build));
			Result.append ("] ")
		end;
		from
			it := optional_list.iterator
		until
			it.finished
		loop
			Result.extend ('[');
			Result.append (add_option_marker(optional_list.key(it)))
			Result.append (" [");
			Result.append (optional_list.item(it));
			Result.append ("]] ");
			it.forth;
		end
		from
			it := param_list.iterator
		until
			it.finished
		loop
			Result.extend ('[');
			Result.append (add_option_marker(param_list.key(it)));
			Result.append (" ");
			Result.append (param_list.item(it));
			Result.append ("] ");
			it.forth;
		end
	end -- help

	search (arg: like last_search) is
		-- Look for an option in the list
	do
		if arg.empty then
			!!last_search.make (0);
		else
			last_search := arg.substring (1, 1);
		end
		if arg.count <= 1 then
			!!remaining.make (0);
		else
			remaining := arg.substring (2, arg.count);
		end;
		simple.search (last_search)
		optional_list.search (last_search)
		param_list.search (last_search);
		simple_found := simple.found;
		optional_found := optional_list.found;
		parameter_found := param_list.found;
	ensure then
		remaining_changed: remaining /= old remaining
	end -- search

feature -- Search result interrogators

	parameter_found: BOOLEAN;

	optional_found: BOOLEAN;

	simple_found: BOOLEAN;
	
	last_search: STRING;

	remaining: like last_search;

end -- class CHARACTER_MATCHER
