-- Multiple matcher options processor

indexing

	type: user;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 19:18:46 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: MULTIOP.E $
	-- Revision 1.2  1993/06/24  19:18:46  Neil_Wilson
	-- Added invariant
	-- Completed header comments
	--
	-- Revision 1.1  1993/06/23  22:11:28  Neil_Wilson
	-- Initial revision
	--

class MULTIPLE_OPTION

inherit

	OPTION_PROCESSOR

creation

	make

feature -- Full initialisation

	make (arg: COLLECTION [OPTION_MATCHER]) is
		-- Set up sub-objects
	require
		matcher_available: arg /= Void
		one_option_matcher: not arg.empty
	do
		!SHORT_LIST [STRING]!arguments.make (false);
		!!options.make;
		list := arg;
		state := Argument;
	ensure
		start_state_correct: state = Argument;
		list_stored: list = arg
	end -- make

	help: STRING is
		-- Multiple matcher help message
	local
		it: ITERATOR
	do
		from
			!!Result.make (0)
			it := list.iterator
		until
			it.finished
		loop
			Result.append (list.item (it).help);
			it.forth
		end;
	end -- help

feature {NONE}

	scan_for (arg: STRING) is
		-- Attempt to find matcher in 'list'.
		-- Attach matcher to 'match'.
	local
		it: ITERATOR
	do
		from
			it := list.iterator
			is_option_string := false
		invariant
			scan_loop_consistent:
			    (match = Void implies not is_option_string)
			    and then (match /= Void implies
			    (is_option_string = match.is_option_string (arg)))
		until
			is_option_string or it.finished
		loop
			match := list.item (it)
			is_option_string := match.is_option_string (arg)
			it.forth
		end
	end -- scan_for

	list: COLLECTION [OPTION_MATCHER]
		-- The multiple matchers

invariant

	list_available: list /= Void
	at_least_one_matcher: not list.empty

end -- class MULTIPLE_OPTION
