-- "Mixin Attributes" required by options processors.

indexing
	
	type: mixin;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/07 21:22:55 $";
	revision: "$Revision: 1.2 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: OPT_ATTR.E $
	-- Revision 1.2  1993/06/07  21:22:55  Neil_Wilson
	-- Defer 'help' implementation
	--
	-- Revision 1.1  1993/05/31  10:30:14  Neil_Wilson
	-- Initial revision
	--

deferred class OPTION_ATTRIBUTES

feature

	options: DICTIONARY [STRING, STRING];
		-- Associative array consisting of the 'set' options.
		-- They are provided in <option,  parameter>  pairs,
		-- keyed on the option. 'Parameter' maybe Void.

	has_invalid_option: BOOLEAN;
		-- True if the processor detected an option not in the
		-- 'Valid' list.

	invalid_option: STRING;
		-- The value of the invalid option.

	help: STRING is
		-- Provides a usage help message based on the valid option
		-- list.
	deferred
	end -- help

invariant

	options_available: options /= Void;

	help_available: help /= Void;

	consistent_error: has_invalid_option implies invalid_option /= Void

end -- class OPTION_ATTRIBUTES
