-- Environment with the arguments processed for options.

indexing
	
	type: server;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/08/21 08:57:30 $";
	revision: "$Revision: 1.5 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: prep_env.e $
	-- Revision 1.5  1993/08/21  08:57:30  Neil_Wilson
	-- Alter export clause to prevent compilation failure
	-- with non-PC versions of Eiffel/S.
	--
	-- Revision 1.4  1993/06/24  19:31:51  Neil_Wilson
	-- Uses new option processor
	--
	-- Revision 1.3  1993/06/10  20:40:08  Neil_Wilson
	-- Fixed problem with 'require' violations during creation.
	-- Tidied up class layout
	--
	-- Revision 1.2  1993/06/07  21:20:59  Neil_Wilson
	-- Make arguments an array,
	-- for historical compatibility.
	--
	-- Revision 1.1  1993/05/31  14:39:08  Neil_Wilson
	-- Initial revision
	--

class PREPARED_ENVIRONMENT

inherit

	ENVIRONMENT
		redefine
			arg_count,
			arg_item
		select
			arg_count,
			arg_item
		end;

	ENVIRONMENT
		rename
			arg_count as basic_arg_count,
			arg_item as basic_arg_item
		export
			{NONE} basic_arg_count, basic_arg_item
		end;

	OPTION_ATTRIBUTES

creation

	make

feature -- Routines to prepare the environment

	make (op: OPTION_PROCESSOR) is
		-- Prepare the environment using the options processor
	require
		processor_available: op /= Void;
	local
		i: INTEGER;
		it: ITERATOR;
	do
		from
			i := 1;
		until
			i > basic_arg_count or op.has_invalid_option
		loop
			op.process (basic_arg_item(i));
			i := i + 1;
		end;
		if basic_arg_count > 0 and not op.has_invalid_option then
		    	op.stop
		end;
		from
			it := op.arguments.iterator
			!!arguments.make (1, op.arguments.count);
			i := 1;
		until
			it.finished
		loop
			arguments.put (op.arguments.item (it), i);
			it.forth;
			i := i + 1;
		end;
		options := op.options;
		has_invalid_option := op.has_invalid_option;
		invalid_option := op.invalid_option;
		help := "Usage: ";
		help.append (program_name);
		help.extend (' ');
		help.append (op.help);
	end -- make

	arguments : ARRAY [STRING];

	help: STRING;
		-- Provides a usage help message based on the valid option
		-- list.

feature -- Redefinitions of ENVIRONMENT features

	arg_count: INTEGER is
		-- Number of non-option arguments
	do
	    if arguments = Void then
		Result := basic_arg_count
	    else
		Result := arguments.count
	    end
	end -- arg_count

	arg_item (index: INTEGER): STRING is
		-- Access the non-option argument array
	do
		Result :=  arguments.item (index)
	end -- arg_item

invariant

	arguments_available: arguments /= Void

end -- class PREPARED_ENVIRONMENT
