-- Single matcher options processor

indexing

	type: user;
	author: "$Author: Neil_Wilson $", "(c) 1993";
	date: "$Date: 1993/06/24 19:20:23 $";
	revision: "$Revision: 1.3 $";
	licence: "GNU Library GPL - see file README.LIB";
	log: 
	-- $Log: SINGLEOP.E $
	-- Revision 1.3  1993/06/24  19:20:23  Neil_Wilson
	-- Added invariant and post-conditions.
	--
	-- Revision 1.2  1993/06/20  12:17:33  Neil_Wilson
	-- Decoupled matcher from processor
	--
	-- Revision 1.1  1993/06/10  20:38:28  Neil_Wilson
	-- Initial revision
	--

class SINGLE_OPTION

inherit

	OPTION_PROCESSOR

creation

	make

feature -- Full initialisation

	make (arg: OPTION_MATCHER) is
		-- Set up sub-objects
	require
		matcher_available: arg /= Void
	do
		!SHORT_LIST [STRING]!arguments.make (false);
		!!options.make;
		match := arg;
		state := Argument;
	ensure
		state = Argument;
		match = arg
	end -- make

	help: STRING is
		-- Single matcher help message
	do
		Result := match.help;
	end -- help

feature {NONE}

	scan_for (arg: STRING) is
		-- Single matcher option scan.
	do
		is_option_string := match.is_option_string (arg);
	end -- scan_for

invariant

	matcher_available: match /= Void

end -- class SINGLE_OPTION
